/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import sun.lwawt.LWTextComponentPeer;
import sun.lwawt.PlatformComponent;

final class LWTextAreaPeer
extends LWTextComponentPeer<TextArea, ScrollableJTextArea>
implements TextAreaPeer {
    private static final int DEFAULT_COLUMNS = 60;
    private static final int DEFAULT_ROWS = 10;

    LWTextAreaPeer(TextArea textArea, PlatformComponent platformComponent) {
        super(textArea, platformComponent);
    }

    @Override
    protected ScrollableJTextArea createDelegate() {
        return new ScrollableJTextArea();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void initializeImpl() {
        super.initializeImpl();
        int n = ((TextArea)this.getTarget()).getScrollbarVisibility();
        Object object = this.getDelegateLock();
        synchronized (object) {
            this.setScrollBarVisibility(n);
        }
    }

    @Override
    JTextComponent getTextComponent() {
        return ((ScrollableJTextArea)this.getDelegate()).getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Cursor getCursor(Point point) {
        boolean bl;
        Object object = this.getDelegateLock();
        synchronized (object) {
            bl = ((ScrollableJTextArea)this.getDelegate()).getViewport().getBounds().contains(point);
        }
        return bl ? super.getCursor(point) : null;
    }

    @Override
    protected Component getDelegateFocusOwner() {
        return this.getTextComponent();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    @Override
    public Dimension getMinimumSize(int n, int n2) {
        return this.getPreferredSize(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize(int n, int n2) {
        Dimension dimension = super.getPreferredSize(n, n2);
        Object object = this.getDelegateLock();
        synchronized (object) {
            JScrollBar jScrollBar = ((ScrollableJTextArea)this.getDelegate()).getVerticalScrollBar();
            JScrollBar jScrollBar2 = ((ScrollableJTextArea)this.getDelegate()).getHorizontalScrollBar();
            int n3 = jScrollBar != null ? jScrollBar.getWidth() : 0;
            int n4 = jScrollBar2 != null ? jScrollBar2.getHeight() : 0;
            return new Dimension(dimension.width + n3, dimension.height + n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(String string, int n) {
        ScrollableJTextArea scrollableJTextArea = (ScrollableJTextArea)this.getDelegate();
        Object object = this.getDelegateLock();
        synchronized (object) {
            JScrollBar jScrollBar;
            JTextArea jTextArea = scrollableJTextArea.getView();
            boolean bl = n >= jTextArea.getDocument().getLength() && jTextArea.getDocument().getLength() != 0;
            jTextArea.insert(string, n);
            this.revalidate();
            if (bl && (jScrollBar = scrollableJTextArea.getVerticalScrollBar()) != null) {
                jScrollBar.setValue(jScrollBar.getMaximum() - jScrollBar.getVisibleAmount());
            }
        }
        this.repaintPeer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceRange(String string, int n, int n2) {
        Object object = this.getDelegateLock();
        synchronized (object) {
            Document document = this.getTextComponent().getDocument();
            document.removeDocumentListener(this);
            ((ScrollableJTextArea)this.getDelegate()).getView().replaceRange(string, n, n2);
            this.revalidate();
            this.postEvent(new TextEvent(this.getTarget(), 900));
            document.addDocumentListener(this);
        }
        this.repaintPeer();
    }

    private void setScrollBarVisibility(int n) {
        ScrollableJTextArea scrollableJTextArea = (ScrollableJTextArea)this.getDelegate();
        JTextArea jTextArea = scrollableJTextArea.getView();
        jTextArea.setLineWrap(false);
        switch (n) {
            case 3: {
                scrollableJTextArea.setHorizontalScrollBarPolicy(31);
                scrollableJTextArea.setVerticalScrollBarPolicy(21);
                jTextArea.setLineWrap(true);
                break;
            }
            case 1: {
                scrollableJTextArea.setHorizontalScrollBarPolicy(31);
                scrollableJTextArea.setVerticalScrollBarPolicy(22);
                jTextArea.setLineWrap(true);
                break;
            }
            case 2: {
                scrollableJTextArea.setVerticalScrollBarPolicy(21);
                scrollableJTextArea.setHorizontalScrollBarPolicy(32);
                break;
            }
            default: {
                scrollableJTextArea.setHorizontalScrollBarPolicy(32);
                scrollableJTextArea.setVerticalScrollBarPolicy(22);
            }
        }
    }

    final class ScrollableJTextArea
    extends JScrollPane {
        ScrollableJTextArea() {
            this.getViewport().setView(new JTextAreaDelegate());
        }

        public JTextArea getView() {
            return (JTextArea)this.getViewport().getView();
        }

        @Override
        public void setEnabled(boolean bl) {
            this.getViewport().getView().setEnabled(bl);
            super.setEnabled(bl);
        }

        private final class JTextAreaDelegate
        extends JTextArea {
            JTextAreaDelegate() {
            }

            @Override
            public void replaceSelection(String string) {
                this.getDocument().removeDocumentListener(LWTextAreaPeer.this);
                super.replaceSelection(string);
                LWTextAreaPeer.this.postTextEvent();
                this.getDocument().addDocumentListener(LWTextAreaPeer.this);
            }

            @Override
            public boolean hasFocus() {
                return ((TextArea)LWTextAreaPeer.this.getTarget()).hasFocus();
            }

            @Override
            public Point getLocationOnScreen() {
                return LWTextAreaPeer.this.getLocationOnScreen();
            }
        }
    }
}

