/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmConstraints;
import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import sun.security.ssl.CipherSuite;
import sun.security.util.DisabledAlgorithmConstraints;

final class SSLAlgorithmConstraints
implements AlgorithmConstraints {
    private static final AlgorithmConstraints tlsDisabledAlgConstraints = new TLSDisabledAlgConstraints();
    private static final AlgorithmConstraints x509DisabledAlgConstraints = new X509DisabledAlgConstraints();
    private AlgorithmConstraints userAlgConstraints = null;
    private AlgorithmConstraints peerAlgConstraints = null;
    private boolean enabledX509DisabledAlgConstraints = true;

    SSLAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.userAlgConstraints = algorithmConstraints;
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, boolean bl) {
        if (sSLSocket != null) {
            this.userAlgConstraints = sSLSocket.getSSLParameters().getAlgorithmConstraints();
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, boolean bl) {
        if (sSLEngine != null) {
            this.userAlgConstraints = sSLEngine.getSSLParameters().getAlgorithmConstraints();
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLSocket sSLSocket, String[] stringArray, boolean bl) {
        if (sSLSocket != null) {
            this.userAlgConstraints = sSLSocket.getSSLParameters().getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    SSLAlgorithmConstraints(SSLEngine sSLEngine, String[] stringArray, boolean bl) {
        if (sSLEngine != null) {
            this.userAlgConstraints = sSLEngine.getSSLParameters().getAlgorithmConstraints();
            this.peerAlgConstraints = new SupportedSignatureAlgorithmConstraints(stringArray);
        }
        if (!bl) {
            this.enabledX509DisabledAlgConstraints = false;
        }
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, algorithmParameters);
        }
        return bl;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, Key key) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, key);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, key);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, key);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, key);
        }
        return bl;
    }

    @Override
    public boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
        boolean bl = true;
        if (this.peerAlgConstraints != null) {
            bl = this.peerAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.userAlgConstraints != null) {
            bl = this.userAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl) {
            bl = tlsDisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        if (bl && this.enabledX509DisabledAlgConstraints) {
            bl = x509DisabledAlgConstraints.permits(set, string, key, algorithmParameters);
        }
        return bl;
    }

    private static class X509DisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        X509DisabledAlgConstraints() {
            super("jdk.certpath.disabledAlgorithms");
        }

        protected Set<String> decomposes(String string) {
            if (string.startsWith("SSL_") || string.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    if (cipherSuite.keyExchange != null) {
                        hashSet.addAll(this.decomposes(cipherSuite.keyExchange, true));
                    }
                    return hashSet;
                }
            }
            return super.decomposes(string);
        }
    }

    private static class TLSDisabledAlgConstraints
    extends BasicDisabledAlgConstraints {
        TLSDisabledAlgConstraints() {
            super("jdk.tls.disabledAlgorithms");
        }

        protected Set<String> decomposes(String string) {
            if (string.startsWith("SSL_") || string.startsWith("TLS_")) {
                CipherSuite cipherSuite = null;
                try {
                    cipherSuite = CipherSuite.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (cipherSuite != null) {
                    HashSet<String> hashSet = new HashSet<String>();
                    if (cipherSuite.keyExchange != null) {
                        hashSet.addAll(this.decomposes(cipherSuite.keyExchange, false));
                    }
                    if (cipherSuite.cipher != null) {
                        hashSet.addAll(this.decomposes(cipherSuite.cipher));
                    }
                    if (cipherSuite.macAlg != null) {
                        hashSet.addAll(this.decomposes(cipherSuite.macAlg));
                    }
                    return hashSet;
                }
            }
            return super.decomposes(string);
        }
    }

    private static class BasicDisabledAlgConstraints
    extends DisabledAlgorithmConstraints {
        BasicDisabledAlgConstraints(String string) {
            super(string);
        }

        protected Set<String> decomposes(CipherSuite.KeyExchange keyExchange, boolean bl) {
            HashSet<String> hashSet = new HashSet<String>();
            switch (keyExchange) {
                case K_NULL: {
                    if (bl) break;
                    hashSet.add("NULL");
                    break;
                }
                case K_RSA: {
                    hashSet.add("RSA");
                    break;
                }
                case K_RSA_EXPORT: {
                    hashSet.add("RSA");
                    hashSet.add("RSA_EXPORT");
                    break;
                }
                case K_DH_RSA: {
                    hashSet.add("RSA");
                    hashSet.add("DH");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DH_RSA");
                    break;
                }
                case K_DH_DSS: {
                    hashSet.add("DSA");
                    hashSet.add("DSS");
                    hashSet.add("DH");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DH_DSS");
                    break;
                }
                case K_DHE_DSS: {
                    hashSet.add("DSA");
                    hashSet.add("DSS");
                    hashSet.add("DH");
                    hashSet.add("DHE");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DHE_DSS");
                    break;
                }
                case K_DHE_RSA: {
                    hashSet.add("RSA");
                    hashSet.add("DH");
                    hashSet.add("DHE");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DHE_RSA");
                    break;
                }
                case K_DH_ANON: {
                    if (bl) break;
                    hashSet.add("ANON");
                    hashSet.add("DH");
                    hashSet.add("DiffieHellman");
                    hashSet.add("DH_ANON");
                    break;
                }
                case K_ECDH_ECDSA: {
                    hashSet.add("ECDH");
                    hashSet.add("ECDSA");
                    hashSet.add("ECDH_ECDSA");
                    break;
                }
                case K_ECDH_RSA: {
                    hashSet.add("ECDH");
                    hashSet.add("RSA");
                    hashSet.add("ECDH_RSA");
                    break;
                }
                case K_ECDHE_ECDSA: {
                    hashSet.add("ECDHE");
                    hashSet.add("ECDSA");
                    hashSet.add("ECDHE_ECDSA");
                    break;
                }
                case K_ECDHE_RSA: {
                    hashSet.add("ECDHE");
                    hashSet.add("RSA");
                    hashSet.add("ECDHE_RSA");
                    break;
                }
                case K_ECDH_ANON: {
                    if (bl) break;
                    hashSet.add("ECDH");
                    hashSet.add("ANON");
                    hashSet.add("ECDH_ANON");
                    break;
                }
                case K_KRB5: {
                    if (bl) break;
                    hashSet.add("KRB5");
                    break;
                }
                case K_KRB5_EXPORT: {
                    if (bl) break;
                    hashSet.add("KRB5_EXPORT");
                    break;
                }
            }
            return hashSet;
        }

        protected Set<String> decomposes(CipherSuite.BulkCipher bulkCipher) {
            HashSet<String> hashSet = new HashSet<String>();
            if (bulkCipher.transformation != null) {
                hashSet.addAll(super.decomposes(bulkCipher.transformation));
            }
            return hashSet;
        }

        protected Set<String> decomposes(CipherSuite.MacAlg macAlg) {
            HashSet<String> hashSet = new HashSet<String>();
            if (macAlg == CipherSuite.M_MD5) {
                hashSet.add("MD5");
                hashSet.add("HmacMD5");
            } else if (macAlg == CipherSuite.M_SHA) {
                hashSet.add("SHA1");
                hashSet.add("SHA-1");
                hashSet.add("HmacSHA1");
            } else if (macAlg == CipherSuite.M_SHA256) {
                hashSet.add("SHA256");
                hashSet.add("SHA-256");
                hashSet.add("HmacSHA256");
            } else if (macAlg == CipherSuite.M_SHA384) {
                hashSet.add("SHA384");
                hashSet.add("SHA-384");
                hashSet.add("HmacSHA384");
            }
            return hashSet;
        }
    }

    private static class SupportedSignatureAlgorithmConstraints
    implements AlgorithmConstraints {
        private String[] supportedAlgorithms;

        SupportedSignatureAlgorithmConstraints(String[] stringArray) {
            this.supportedAlgorithms = stringArray != null ? (String[])stringArray.clone() : null;
        }

        @Override
        public boolean permits(Set<CryptoPrimitive> set, String string, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("No cryptographic primitive specified");
            }
            if (this.supportedAlgorithms == null || this.supportedAlgorithms.length == 0) {
                return false;
            }
            int n = string.indexOf("and");
            if (n > 0) {
                string = string.substring(0, n);
            }
            for (String string2 : this.supportedAlgorithms) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> set, Key key) {
            return true;
        }

        @Override
        public final boolean permits(Set<CryptoPrimitive> set, String string, Key key, AlgorithmParameters algorithmParameters) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("No algorithm name specified");
            }
            return this.permits(set, string, algorithmParameters);
        }
    }
}

