/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XWindowChanges
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 28 : 40;
    }

    @Override
    public int getDataSize() {
        return XWindowChanges.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XWindowChanges(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XWindowChanges() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XWindowChanges.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_x() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_x(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_y() {
        log.finest("");
        return Native.getInt(this.pData + 4L);
    }

    public void set_y(int n) {
        log.finest("");
        Native.putInt(this.pData + 4L, n);
    }

    public int get_width() {
        log.finest("");
        return Native.getInt(this.pData + 8L);
    }

    public void set_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 8L, n);
    }

    public int get_height() {
        log.finest("");
        return Native.getInt(this.pData + 12L);
    }

    public void set_height(int n) {
        log.finest("");
        Native.putInt(this.pData + 12L, n);
    }

    public int get_border_width() {
        log.finest("");
        return Native.getInt(this.pData + 16L);
    }

    public void set_border_width(int n) {
        log.finest("");
        Native.putInt(this.pData + 16L, n);
    }

    public long get_sibling() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 24));
    }

    public void set_sibling(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 20 : 24), l);
    }

    public int get_stack_mode() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 32));
    }

    public void set_stack_mode(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 24 : 32), n);
    }

    @Override
    String getName() {
        return "XWindowChanges";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(280);
        stringBuilder.append("x = ").append(this.get_x()).append(", ");
        stringBuilder.append("y = ").append(this.get_y()).append(", ");
        stringBuilder.append("width = ").append(this.get_width()).append(", ");
        stringBuilder.append("height = ").append(this.get_height()).append(", ");
        stringBuilder.append("border_width = ").append(this.get_border_width()).append(", ");
        stringBuilder.append("sibling = ").append(this.get_sibling()).append(", ");
        stringBuilder.append("stack_mode = ").append(this.get_stack_mode()).append(", ");
        return stringBuilder.toString();
    }
}

