/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.plaf.basic.LazyActionMap;
import javax.swing.text.Position;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

public class BasicTreeUI
extends TreeUI {
    private static final StringBuilder BASELINE_COMPONENT_KEY = new StringBuilder("Tree.baselineComponent");
    private static final Actions SHARED_ACTION = new Actions();
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable<TreePath, Boolean> drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    private int leadRow;
    private boolean ignoreLAChange;
    private boolean leftToRight;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;
    private boolean paintLines = true;
    private boolean lineTypeDashed;
    private long timeFactor = 1000L;
    private Handler handler;
    private MouseEvent releaseEvent;
    private static final TransferHandler defaultTransferHandler = new TreeTransferHandler();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("selectPrevious"));
        lazyActionMap.put(new Actions("selectPreviousChangeLead"));
        lazyActionMap.put(new Actions("selectPreviousExtendSelection"));
        lazyActionMap.put(new Actions("selectNext"));
        lazyActionMap.put(new Actions("selectNextChangeLead"));
        lazyActionMap.put(new Actions("selectNextExtendSelection"));
        lazyActionMap.put(new Actions("selectChild"));
        lazyActionMap.put(new Actions("selectChildChangeLead"));
        lazyActionMap.put(new Actions("selectParent"));
        lazyActionMap.put(new Actions("selectParentChangeLead"));
        lazyActionMap.put(new Actions("scrollUpChangeSelection"));
        lazyActionMap.put(new Actions("scrollUpChangeLead"));
        lazyActionMap.put(new Actions("scrollUpExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeSelection"));
        lazyActionMap.put(new Actions("scrollDownExtendSelection"));
        lazyActionMap.put(new Actions("scrollDownChangeLead"));
        lazyActionMap.put(new Actions("selectFirst"));
        lazyActionMap.put(new Actions("selectFirstChangeLead"));
        lazyActionMap.put(new Actions("selectFirstExtendSelection"));
        lazyActionMap.put(new Actions("selectLast"));
        lazyActionMap.put(new Actions("selectLastChangeLead"));
        lazyActionMap.put(new Actions("selectLastExtendSelection"));
        lazyActionMap.put(new Actions("toggle"));
        lazyActionMap.put(new Actions("cancel"));
        lazyActionMap.put(new Actions("startEditing"));
        lazyActionMap.put(new Actions("selectAll"));
        lazyActionMap.put(new Actions("clearSelection"));
        lazyActionMap.put(new Actions("scrollLeft"));
        lazyActionMap.put(new Actions("scrollRight"));
        lazyActionMap.put(new Actions("scrollLeftExtendSelection"));
        lazyActionMap.put(new Actions("scrollRightExtendSelection"));
        lazyActionMap.put(new Actions("scrollRightChangeLead"));
        lazyActionMap.put(new Actions("scrollLeftChangeLead"));
        lazyActionMap.put(new Actions("expand"));
        lazyActionMap.put(new Actions("collapse"));
        lazyActionMap.put(new Actions("moveSelectionToParent"));
        lazyActionMap.put(new Actions("addToSelection"));
        lazyActionMap.put(new Actions("toggleAndAnchor"));
        lazyActionMap.put(new Actions("extendTo"));
        lazyActionMap.put(new Actions("moveSelectionTo"));
        lazyActionMap.put(TransferHandler.getCutAction());
        lazyActionMap.put(TransferHandler.getCopyAction());
        lazyActionMap.put(TransferHandler.getPasteAction());
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl) {
        if (this.getRowHeight() < 1) {
            bl = false;
        }
        if (this.largeModel != bl) {
            this.completeEditing();
            this.largeModel = bl;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.updateLayoutCacheExpandedNodesIfNecessary();
            this.updateSize();
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n) {
        this.completeEditing();
        if (this.treeState != null) {
            this.setLargeModel(this.tree.isLargeModel());
            this.treeState.setRowHeight(n);
            this.updateSize();
        }
    }

    protected int getRowHeight() {
        return this.tree == null ? -1 : this.tree.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    protected void setModel(TreeModel treeModel) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(treeModel);
            this.updateLayoutCacheExpandedNodesIfNecessary();
            this.updateSize();
        }
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.setRootVisible(bl);
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    protected void setShowsRootHandles(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.updateCellEditor();
    }

    protected TreeCellEditor getCellEditor() {
        return this.tree != null ? this.tree.getCellEditor() : null;
    }

    protected void setEditable(boolean bl) {
        this.updateCellEditor();
    }

    protected boolean isEditable() {
        return this.tree != null ? this.tree.isEditable() : false;
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        this.completeEditing();
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            if (this.selectionModelPropertyChangeListener != null) {
                this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
            }
            if (this.treeSelectionListener != null) {
                this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(this.treeSelectionModel);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    @Override
    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        if (jTree != null && this.treeState != null) {
            return this.getPathBounds(treePath, jTree.getInsets(), new Rectangle());
        }
        return null;
    }

    private Rectangle getPathBounds(TreePath treePath, Insets insets, Rectangle rectangle) {
        if ((rectangle = this.treeState.getBounds(treePath, rectangle)) != null) {
            rectangle.x = this.leftToRight ? (rectangle.x += insets.left) : this.tree.getWidth() - (rectangle.x + rectangle.width) - insets.right;
            rectangle.y += insets.top;
        }
        return rectangle;
    }

    @Override
    public TreePath getPathForRow(JTree jTree, int n) {
        return this.treeState != null ? this.treeState.getPathForRow(n) : null;
    }

    @Override
    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState != null ? this.treeState.getRowForPath(treePath) : -1;
    }

    @Override
    public int getRowCount(JTree jTree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    @Override
    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        if (jTree != null && this.treeState != null) {
            return this.treeState.getPathClosestTo(n, n2 -= jTree.getInsets().top);
        }
        return null;
    }

    @Override
    public boolean isEditing(JTree jTree) {
        return this.editingComponent != null;
    }

    @Override
    public boolean stopEditing(JTree jTree) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    @Override
    public void cancelEditing(JTree jTree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    @Override
    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        if (treePath != null && jTree.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    @Override
    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
        this.completeUIInstall();
    }

    protected void prepareForUIInstall() {
        this.drawingCache = new Hashtable(7);
        this.leftToRight = BasicGraphicsUtils.isLeftToRight(this.tree);
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.leadRow = -1;
        this.preferredSize = new Dimension();
        this.largeModel = this.tree.isLargeModel();
        if (this.getRowHeight() <= 0) {
            this.largeModel = false;
        }
        this.setModel(this.tree.getModel());
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        this.updateSize();
    }

    protected void installDefaults() {
        if (this.tree.getBackground() == null || this.tree.getBackground() instanceof UIResource) {
            this.tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (this.tree.getFont() == null || this.tree.getFont() instanceof UIResource) {
            this.tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
        this.setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
        this.setRightChildIndent((Integer)UIManager.get("Tree.rightChildIndent"));
        LookAndFeel.installProperty(this.tree, "rowHeight", UIManager.get("Tree.rowHeight"));
        this.largeModel = this.tree.isLargeModel() && this.tree.getRowHeight() > 0;
        Object object = UIManager.get("Tree.scrollsOnExpand");
        if (object != null) {
            LookAndFeel.installProperty(this.tree, "scrollsOnExpand", object);
        }
        this.paintLines = UIManager.getBoolean("Tree.paintLines");
        this.lineTypeDashed = UIManager.getBoolean("Tree.lineTypeDashed");
        Long l = (Long)UIManager.get("Tree.timeFactor");
        this.timeFactor = l != null ? l : 1000L;
        Object object2 = UIManager.get("Tree.showsRootHandles");
        if (object2 != null) {
            LookAndFeel.installProperty(this.tree, "showsRootHandles", object2);
        }
    }

    protected void installListeners() {
        TransferHandler transferHandler;
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tree.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tree.addMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if ((this.treeModelListener = this.createTreeModelListener()) != null && this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if ((this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
        if ((transferHandler = this.tree.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.tree.setTransferHandler(defaultTransferHandler);
            if (this.tree.getDropTarget() instanceof UIResource) {
                this.tree.setDropTarget(null);
            }
        }
        LookAndFeel.installProperty(this.tree, "opaque", Boolean.TRUE);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tree, 1, inputMap);
        inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tree, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.tree, BasicTreeUI.class, "Tree.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)DefaultLookup.get(this.tree, this, "Tree.ancestorInputMap");
        }
        if (n == 0) {
            InputMap inputMap;
            InputMap inputMap2 = (InputMap)DefaultLookup.get(this.tree, this, "Tree.focusInputMap");
            if (this.tree.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)DefaultLookup.get(this.tree, this, "Tree.focusInputMap.RightToLeft")) == null) {
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            return inputMap;
        }
        return null;
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected KeyListener createKeyListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return this.getHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return this.getHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return this.getHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return this.getHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return defaultTreeCellEditor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return this.getHandler();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void prepareForUIUninstall() {
    }

    protected void completeUIUninstall() {
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.cellEditor = null;
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.setSelectionModel(null);
        this.treeState = null;
        this.drawingCache = null;
        this.selectionModelPropertyChangeListener = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        this.treeSelectionListener = null;
        this.treeExpansionListener = null;
    }

    protected void uninstallDefaults() {
        if (this.tree.getTransferHandler() instanceof UIResource) {
            this.tree.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.tree.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
            if (this.mouseListener instanceof MouseMotionListener) {
                this.tree.removeMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
            }
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        }
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.handler = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tree, null);
        SwingUtilities.replaceUIInputMap(this.tree, 1, null);
        SwingUtilities.replaceUIInputMap(this.tree, 0, null);
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    private void redoTheLayout() {
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        int n3;
        int n4;
        super.getBaseline(jComponent, n, n2);
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Component component = (Component)uIDefaults.get(BASELINE_COMPONENT_KEY);
        if (component == null) {
            TreeCellRenderer treeCellRenderer = this.createDefaultCellRenderer();
            component = treeCellRenderer.getTreeCellRendererComponent(this.tree, "a", false, false, false, -1, false);
            uIDefaults.put(BASELINE_COMPONENT_KEY, component);
        }
        if ((n4 = this.tree.getRowHeight()) > 0) {
            n3 = component.getBaseline(Integer.MAX_VALUE, n4);
        } else {
            Dimension dimension = component.getPreferredSize();
            n3 = component.getBaseline(dimension.width, dimension.height);
        }
        return n3 + this.tree.getInsets().top;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent jComponent) {
        super.getBaselineResizeBehavior(jComponent);
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.tree != jComponent) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n = this.treeState.getRowForPath(treePath);
        int n2 = rectangle.y + rectangle.height;
        this.drawingCache.clear();
        if (treePath != null && enumeration != null) {
            TreePath treePath2 = treePath;
            for (treePath2 = treePath2.getParentPath(); treePath2 != null; treePath2 = treePath2.getParentPath()) {
                this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                this.drawingCache.put(treePath2, Boolean.TRUE);
            }
            boolean bl = false;
            Rectangle rectangle2 = new Rectangle();
            boolean bl2 = this.isRootVisible();
            while (!bl && enumeration.hasMoreElements()) {
                TreePath treePath3 = enumeration.nextElement();
                if (treePath3 != null) {
                    boolean bl3;
                    boolean bl4;
                    boolean bl5 = this.treeModel.isLeaf(treePath3.getLastPathComponent());
                    if (bl5) {
                        bl4 = false;
                        bl3 = false;
                    } else {
                        bl3 = this.treeState.getExpandedState(treePath3);
                        bl4 = this.tree.hasBeenExpanded(treePath3);
                    }
                    Rectangle rectangle3 = this.getPathBounds(treePath3, insets, rectangle2);
                    if (rectangle3 == null) {
                        return;
                    }
                    treePath2 = treePath3.getParentPath();
                    if (treePath2 != null) {
                        if (this.drawingCache.get(treePath2) == null) {
                            this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                            this.drawingCache.put(treePath2, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    } else if (bl2 && n == 0) {
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    }
                    if (this.shouldPaintExpandControl(treePath3, n, bl3, bl4, bl5)) {
                        this.paintExpandControl(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    }
                    this.paintRow(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    if (rectangle3.y + rectangle3.height >= n2) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
        }
        this.paintDropLine(graphics);
        this.rendererPane.removeAll();
        this.drawingCache.clear();
    }

    protected boolean isDropLine(JTree.DropLocation dropLocation) {
        return dropLocation != null && dropLocation.getPath() != null && dropLocation.getChildIndex() != -1;
    }

    protected void paintDropLine(Graphics graphics) {
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        if (!this.isDropLine(dropLocation)) {
            return;
        }
        Color color = UIManager.getColor("Tree.dropLineColor");
        if (color != null) {
            graphics.setColor(color);
            Rectangle rectangle = this.getDropLineRect(dropLocation);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    protected Rectangle getDropLineRect(JTree.DropLocation dropLocation) {
        Rectangle rectangle;
        TreePath treePath = dropLocation.getPath();
        int n = dropLocation.getChildIndex();
        boolean bl = this.leftToRight;
        Insets insets = this.tree.getInsets();
        if (this.tree.getRowCount() == 0) {
            rectangle = new Rectangle(insets.left, insets.top, this.tree.getWidth() - insets.left - insets.right, 0);
        } else {
            TreeModel treeModel = this.getModel();
            Object object = treeModel.getRoot();
            if (treePath.getLastPathComponent() == object && n >= treeModel.getChildCount(object)) {
                Rectangle rectangle2;
                rectangle = this.tree.getRowBounds(this.tree.getRowCount() - 1);
                rectangle.y += rectangle.height;
                if (!this.tree.isRootVisible()) {
                    rectangle2 = this.tree.getRowBounds(0);
                } else if (treeModel.getChildCount(object) == 0) {
                    rectangle2 = this.tree.getRowBounds(0);
                    rectangle2.x += this.totalChildIndent;
                    rectangle2.width -= this.totalChildIndent + this.totalChildIndent;
                } else {
                    TreePath treePath2 = treePath.pathByAddingChild(treeModel.getChild(object, treeModel.getChildCount(object) - 1));
                    rectangle2 = this.tree.getPathBounds(treePath2);
                }
                rectangle.x = rectangle2.x;
                rectangle.width = rectangle2.width;
            } else {
                rectangle = this.tree.getPathBounds(treePath.pathByAddingChild(treeModel.getChild(treePath.getLastPathComponent(), n)));
            }
        }
        if (rectangle.y != 0) {
            --rectangle.y;
        }
        if (!bl) {
            rectangle.x = rectangle.x + rectangle.width - 100;
        }
        rectangle.width = 100;
        rectangle.height = 2;
        return rectangle;
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!this.paintLines) {
            return;
        }
        int n2 = treePath.getPathCount() - 1;
        if ((n2 == 0 || n2 == 1 && !this.isRootVisible()) && !this.getShowsRootHandles()) {
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle.y;
        int n6 = rectangle.y + rectangle.height;
        int n7 = rectangle2.y + rectangle2.height / 2;
        if (this.leftToRight) {
            int n8 = rectangle2.x - this.getRightChildIndent();
            int n9 = rectangle2.x - this.getHorizontalLegBuffer();
            if (n7 >= n5 && n7 < n6 && n9 >= n3 && n8 < n4 && n8 < n9) {
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n7, n8, n9 - 1);
            }
        } else {
            int n10 = rectangle2.x + rectangle2.width + this.getHorizontalLegBuffer();
            int n11 = rectangle2.x + rectangle2.width + this.getRightChildIndent();
            if (n7 >= n5 && n7 < n6 && n11 >= n3 && n10 < n4 && n10 < n11) {
                graphics.setColor(this.getHashColor());
                this.paintHorizontalLine(graphics, this.tree, n7, n10, n11 - 1);
            }
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (!this.paintLines) {
            return;
        }
        int n = treePath.getPathCount() - 1;
        if (n == 0 && !this.getShowsRootHandles() && !this.isRootVisible()) {
            return;
        }
        int n2 = this.getRowX(-1, n + 1);
        n2 = this.leftToRight ? n2 - this.getRightChildIndent() + insets.left : this.tree.getWidth() - n2 - insets.right + this.getRightChildIndent() - 1;
        int n3 = rectangle.x;
        int n4 = rectangle.x + (rectangle.width - 1);
        if (n2 >= n3 && n2 <= n4) {
            int n5;
            Object object;
            TreeModel treeModel;
            int n6 = rectangle.y;
            int n7 = rectangle.y + rectangle.height;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
            Rectangle rectangle3 = this.getPathBounds(this.tree, this.getLastChildPath(treePath));
            if (rectangle3 == null) {
                return;
            }
            int n8 = rectangle2 == null ? Math.max(insets.top + this.getVerticalLegBuffer(), n6) : Math.max(rectangle2.y + rectangle2.height + this.getVerticalLegBuffer(), n6);
            if (n == 0 && !this.isRootVisible() && (treeModel = this.getModel()) != null && treeModel.getChildCount(object = treeModel.getRoot()) > 0 && (rectangle2 = this.getPathBounds(this.tree, treePath.pathByAddingChild(treeModel.getChild(object, 0)))) != null) {
                n8 = Math.max(insets.top + this.getVerticalLegBuffer(), rectangle2.y + rectangle2.height / 2);
            }
            if (n8 <= (n5 = Math.min(rectangle3.y + rectangle3.height / 2, n7))) {
                graphics.setColor(this.getHashColor());
                this.paintVerticalLine(graphics, this.tree, n2, n8, n5);
            }
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        if (!(bl3 || bl2 && this.treeModel.getChildCount(object) <= 0)) {
            int n2 = this.leftToRight ? rectangle2.x - this.getRightChildIndent() + 1 : rectangle2.x + rectangle2.width + this.getRightChildIndent() - 1;
            int n3 = rectangle2.y + rectangle2.height / 2;
            if (bl) {
                Icon icon = this.getExpandedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n2, n3);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n2, n3);
                }
            }
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.editingComponent != null && this.editingRow == n) {
            return;
        }
        int n2 = this.tree.hasFocus() ? this.getLeadSelectionRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), this.tree.isRowSelected(n), bl, bl3, n, n2 == n);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            return false;
        }
        int n2 = treePath.getPathCount() - 1;
        return n2 != 0 && (n2 != 1 || this.isRootVisible()) || this.getShowsRootHandles();
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.lineTypeDashed) {
            this.drawDashedVerticalLine(graphics, n, n2, n3);
        } else {
            graphics.drawLine(n, n2, n, n3);
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        if (this.lineTypeDashed) {
            this.drawDashedHorizontalLine(graphics, n, n2, n3);
        } else {
            graphics.drawLine(n2, n, n3, n);
        }
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    private int findCenteredX(int n, int n2) {
        return this.leftToRight ? n - (int)Math.ceil((double)n2 / 2.0) : n - (int)Math.floor((double)n2 / 2.0);
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, this.findCenteredX(n, icon.getIconWidth()), n2 - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        for (int i = n2; i <= n3; i += 2) {
            graphics.drawLine(i, n, i, n);
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        for (int i = n2; i <= n3; i += 2) {
            graphics.drawLine(n, i, n, i);
        }
    }

    protected int getRowX(int n, int n2) {
        return this.totalChildIndent * (n2 + this.depthOffset);
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    private void updateLayoutCacheExpandedNodesIfNecessary() {
        if (this.treeModel != null && this.treeModel.getRoot() != null) {
            TreePath treePath = new TreePath(this.treeModel.getRoot());
            if (this.tree.isExpanded(treePath)) {
                this.updateLayoutCacheExpandedNodes();
            } else {
                this.treeState.setExpandedState(treePath, false);
            }
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        this.completeEditing();
        if (this.treeState != null) {
            this.treeState.setExpandedState(treePath, true);
            Enumeration<TreePath> enumeration = this.tree.getExpandedDescendants(treePath);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    treePath = enumeration.nextElement();
                    this.treeState.setExpandedState(treePath, true);
                }
            }
            this.updateLeadSelectionRow();
            this.updateSize();
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        int n;
        if (this.treeModel != null && (n = this.treeModel.getChildCount(treePath.getLastPathComponent())) > 0) {
            return treePath.pathByAddingChild(this.treeModel.getChild(treePath.getLastPathComponent(), n - 1));
        }
        return null;
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected void updateCellEditor() {
        TreeCellEditor treeCellEditor;
        this.completeEditing();
        if (this.tree == null) {
            treeCellEditor = null;
        } else if (this.tree.isEditable()) {
            treeCellEditor = this.tree.getCellEditor();
            if (treeCellEditor == null && (treeCellEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(treeCellEditor);
                this.createdCellEditor = true;
            }
        } else {
            treeCellEditor = null;
        }
        if (treeCellEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = treeCellEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (treeCellEditor != null && this.cellEditorListener != null) {
                treeCellEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer == null) {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            } else {
                this.createdRenderer = false;
                this.currentCellRenderer = treeCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            }
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = null;
        }
        this.updateCellEditor();
    }

    protected void configureLayoutCache() {
        if (this.treeState != null && this.tree != null) {
            if (this.nodeDimensions == null) {
                this.nodeDimensions = this.createNodeDimensions();
            }
            this.treeState.setNodeDimensions(this.nodeDimensions);
            this.treeState.setRootVisible(this.tree.isRootVisible());
            this.treeState.setRowHeight(this.tree.getRowHeight());
            this.treeState.setSelectionModel(this.getSelectionModel());
            if (this.treeState.getModel() != this.tree.getModel()) {
                this.treeState.setModel(this.tree.getModel());
            }
            this.updateLayoutCacheExpandedNodesIfNecessary();
            if (this.isLargeModel()) {
                if (this.componentListener == null) {
                    this.componentListener = this.createComponentListener();
                    if (this.componentListener != null) {
                        this.tree.addComponentListener(this.componentListener);
                    }
                }
            } else if (this.componentListener != null) {
                this.tree.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    private void updateSize0() {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
    }

    protected void updateCachedPreferredSize() {
        if (this.treeState != null) {
            Insets insets = this.tree.getInsets();
            if (this.isLargeModel()) {
                JScrollPane jScrollPane;
                JScrollBar jScrollBar;
                Rectangle rectangle = this.tree.getVisibleRect();
                if (rectangle.x == 0 && rectangle.y == 0 && rectangle.width == 0 && rectangle.height == 0 && this.tree.getVisibleRowCount() > 0) {
                    rectangle.width = 1;
                    rectangle.height = this.tree.getRowHeight() * this.tree.getVisibleRowCount();
                } else {
                    rectangle.x -= insets.left;
                    rectangle.y -= insets.top;
                }
                Container container = SwingUtilities.getUnwrappedParent(this.tree);
                if (container instanceof JViewport && (container = container.getParent()) instanceof JScrollPane && (jScrollBar = (jScrollPane = (JScrollPane)container).getHorizontalScrollBar()) != null && jScrollBar.isVisible()) {
                    int n = jScrollBar.getHeight();
                    rectangle.y -= n;
                    rectangle.height += n;
                }
                this.preferredSize.width = this.treeState.getPreferredWidth(rectangle);
            } else {
                this.preferredSize.width = this.treeState.getPreferredWidth(null);
            }
            this.preferredSize.height = this.treeState.getPreferredHeight();
            this.preferredSize.width += insets.left + insets.right;
            this.preferredSize.height += insets.top + insets.bottom;
        }
        this.validCachedPreferredSize = true;
    }

    protected void pathWasExpanded(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(treePath);
        }
    }

    protected void pathWasCollapsed(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(treePath);
        }
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        if (this.tree != null && n >= 0 && n2 < this.getRowCount(this.tree)) {
            boolean bl = DefaultLookup.getBoolean(this.tree, this, "Tree.scrollsHorizontallyAndVertically", false);
            if (n == n2) {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle != null) {
                    if (!bl) {
                        rectangle.x = this.tree.getVisibleRect().x;
                        rectangle.width = 1;
                    }
                    this.tree.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle != null) {
                    Rectangle rectangle2 = this.tree.getVisibleRect();
                    Rectangle rectangle3 = rectangle;
                    int n3 = rectangle.y;
                    int n4 = n3 + rectangle2.height;
                    for (int i = n + 1; i <= n2; ++i) {
                        rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i));
                        if (rectangle3 == null) {
                            return;
                        }
                        if (rectangle3.y + rectangle3.height <= n4) continue;
                        i = n2;
                    }
                    this.tree.scrollRectToVisible(new Rectangle(rectangle2.x, n3, 1, rectangle3.y + rectangle3.height - n3));
                }
            }
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, true);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            TreePath treePath = this.editingPath;
            TreeCellEditor treeCellEditor = this.cellEditor;
            Object object = treeCellEditor.getCellEditorValue();
            Rectangle rectangle = this.getPathBounds(this.tree, this.editingPath);
            boolean bl4 = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingComponent = null;
            this.editingPath = null;
            if (bl) {
                treeCellEditor.stopCellEditing();
            } else if (bl2) {
                treeCellEditor.cancelCellEditing();
            }
            this.tree.remove(component);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(treePath);
                this.updateSize();
            } else if (rectangle != null) {
                rectangle.x = 0;
                rectangle.width = this.tree.getSize().width;
                this.tree.repaint(rectangle);
            }
            if (bl4) {
                this.tree.requestFocus();
            }
            if (bl3) {
                this.treeModel.valueForPathChanged(treePath, object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startEditingOnRelease(TreePath treePath, MouseEvent mouseEvent, MouseEvent mouseEvent2) {
        this.releaseEvent = mouseEvent2;
        try {
            boolean bl = this.startEditing(treePath, mouseEvent);
            return bl;
        }
        finally {
            this.releaseEvent = null;
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isEditing(this.tree) && this.tree.getInvokesStopCellEditing() && !this.stopEditing(this.tree)) {
            return false;
        }
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(treePath)) {
            int n = this.getRowForPath(this.tree, treePath);
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, treePath.getLastPathComponent(), this.tree.isPathSelected(treePath), this.tree.isExpanded(treePath), this.treeModel.isLeaf(treePath.getLastPathComponent()), n);
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                if (rectangle == null) {
                    return false;
                }
                this.editingRow = n;
                Dimension dimension = this.editingComponent.getPreferredSize();
                if (dimension.height != rectangle.height && this.getRowHeight() > 0) {
                    dimension.height = this.getRowHeight();
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(treePath);
                    this.updateSize();
                    rectangle = this.getPathBounds(this.tree, treePath);
                    if (rectangle == null) {
                        return false;
                    }
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.editingPath = treePath;
                if (this.editingComponent instanceof JComponent) {
                    ((JComponent)this.editingComponent).revalidate();
                } else {
                    this.editingComponent.validate();
                }
                this.editingComponent.repaint();
                if (this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    this.tree.setSelectionRow(n);
                    this.stopEditingInCompleteEditing = true;
                }
                Component component = SwingUtilities2.compositeRequestFocus(this.editingComponent);
                boolean bl = true;
                if (mouseEvent != null) {
                    Point point = SwingUtilities.convertPoint(this.tree, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    Component component2 = SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y);
                    if (component2 != null) {
                        MouseInputHandler mouseInputHandler = new MouseInputHandler(this.tree, component2, mouseEvent, component);
                        if (this.releaseEvent != null) {
                            mouseInputHandler.mouseReleased(this.releaseEvent);
                        }
                        bl = false;
                    }
                }
                if (bl && component instanceof JTextField) {
                    ((JTextField)component).selectAll();
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.handleExpandControlClick(treePath, n, n2);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        if (treePath != null && !this.treeModel.isLeaf(treePath.getLastPathComponent())) {
            Insets insets = this.tree.getInsets();
            int n3 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
            int n4 = this.getRowX(this.tree.getRowForPath(treePath), treePath.getPathCount() - 1);
            n4 = this.leftToRight ? n4 + insets.left - this.getRightChildIndent() + 1 : this.tree.getWidth() - n4 - insets.right + this.getRightChildIndent() - 1;
            n4 = this.findCenteredX(n4, n3);
            return n >= n4 && n < n4 + n3;
        }
        return false;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (!this.tree.isExpanded(treePath)) {
            int n = this.getRowForPath(this.tree, treePath);
            this.tree.expandPath(treePath);
            this.updateSize();
            if (n != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    this.ensureRowsAreVisible(n, n + this.treeState.getVisibleChildCount(treePath));
                } else {
                    this.ensureRowsAreVisible(n, n);
                }
            }
        } else {
            this.tree.collapsePath(treePath);
            this.updateSize();
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent);
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isShiftDown();
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        int n = this.tree.getToggleClickCount();
        if (n <= 0) {
            return false;
        }
        return mouseEvent.getClickCount() % n == 0;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isMultiSelectEvent(mouseEvent)) {
            int n;
            TreePath treePath2 = this.getAnchorSelectionPath();
            int n2 = n = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
            if (n == -1 || this.tree.getSelectionModel().getSelectionMode() == 1) {
                this.tree.setSelectionPath(treePath);
            } else {
                int n3 = this.getRowForPath(this.tree, treePath);
                TreePath treePath3 = treePath2;
                if (this.isToggleSelectionEvent(mouseEvent)) {
                    if (this.tree.isRowSelected(n)) {
                        this.tree.addSelectionInterval(n, n3);
                    } else {
                        this.tree.removeSelectionInterval(n, n3);
                        this.tree.addSelectionInterval(n3, n3);
                    }
                } else if (n3 < n) {
                    this.tree.setSelectionInterval(n3, n);
                } else {
                    this.tree.setSelectionInterval(n, n3);
                }
                this.lastSelectedRow = n3;
                this.setAnchorSelectionPath(treePath3);
                this.setLeadSelectionPath(treePath);
            }
        } else if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
            }
            this.lastSelectedRow = this.getRowForPath(this.tree, treePath);
            this.setAnchorSelectionPath(treePath);
            this.setLeadSelectionPath(treePath);
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath != null) {
            return this.treeModel.isLeaf(treePath.getLastPathComponent());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnchorSelectionPath(TreePath treePath) {
        this.ignoreLAChange = true;
        try {
            this.tree.setAnchorSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
    }

    private TreePath getAnchorSelectionPath() {
        return this.tree.getAnchorSelectionPath();
    }

    private void setLeadSelectionPath(TreePath treePath) {
        this.setLeadSelectionPath(treePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLeadSelectionPath(TreePath treePath, boolean bl) {
        Rectangle rectangle = bl ? this.getPathBounds(this.tree, this.getLeadSelectionPath()) : null;
        this.ignoreLAChange = true;
        try {
            this.tree.setLeadSelectionPath(treePath);
        }
        finally {
            this.ignoreLAChange = false;
        }
        this.leadRow = this.getRowForPath(this.tree, treePath);
        if (bl) {
            if (rectangle != null) {
                this.tree.repaint(this.getRepaintPathBounds(rectangle));
            }
            if ((rectangle = this.getPathBounds(this.tree, treePath)) != null) {
                this.tree.repaint(this.getRepaintPathBounds(rectangle));
            }
        }
    }

    private Rectangle getRepaintPathBounds(Rectangle rectangle) {
        if (UIManager.getBoolean("Tree.repaintWholeRow")) {
            rectangle.x = 0;
            rectangle.width = this.tree.getWidth();
        }
        return rectangle;
    }

    private TreePath getLeadSelectionPath() {
        return this.tree.getLeadSelectionPath();
    }

    protected void updateLeadSelectionRow() {
        this.leadRow = this.getRowForPath(this.tree, this.getLeadSelectionPath());
    }

    protected int getLeadSelectionRow() {
        return this.leadRow;
    }

    private void extendSelection(TreePath treePath) {
        TreePath treePath2 = this.getAnchorSelectionPath();
        int n = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
        int n2 = this.getRowForPath(this.tree, treePath);
        if (n == -1) {
            this.tree.setSelectionRow(n2);
        } else {
            if (n < n2) {
                this.tree.setSelectionInterval(n, n2);
            } else {
                this.tree.setSelectionInterval(n2, n);
            }
            this.setAnchorSelectionPath(treePath2);
            this.setLeadSelectionPath(treePath);
        }
    }

    private void repaintPath(TreePath treePath) {
        Rectangle rectangle;
        if (treePath != null && (rectangle = this.getPathBounds(this.tree, treePath)) != null) {
            this.tree.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private static class Actions
    extends UIAction {
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PREVIOUS_CHANGE_LEAD = "selectPreviousChangeLead";
        private static final String SELECT_PREVIOUS_EXTEND_SELECTION = "selectPreviousExtendSelection";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_NEXT_CHANGE_LEAD = "selectNextChangeLead";
        private static final String SELECT_NEXT_EXTEND_SELECTION = "selectNextExtendSelection";
        private static final String SELECT_CHILD = "selectChild";
        private static final String SELECT_CHILD_CHANGE_LEAD = "selectChildChangeLead";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_PARENT_CHANGE_LEAD = "selectParentChangeLead";
        private static final String SCROLL_UP_CHANGE_SELECTION = "scrollUpChangeSelection";
        private static final String SCROLL_UP_CHANGE_LEAD = "scrollUpChangeLead";
        private static final String SCROLL_UP_EXTEND_SELECTION = "scrollUpExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_SELECTION = "scrollDownChangeSelection";
        private static final String SCROLL_DOWN_EXTEND_SELECTION = "scrollDownExtendSelection";
        private static final String SCROLL_DOWN_CHANGE_LEAD = "scrollDownChangeLead";
        private static final String SELECT_FIRST = "selectFirst";
        private static final String SELECT_FIRST_CHANGE_LEAD = "selectFirstChangeLead";
        private static final String SELECT_FIRST_EXTEND_SELECTION = "selectFirstExtendSelection";
        private static final String SELECT_LAST = "selectLast";
        private static final String SELECT_LAST_CHANGE_LEAD = "selectLastChangeLead";
        private static final String SELECT_LAST_EXTEND_SELECTION = "selectLastExtendSelection";
        private static final String TOGGLE = "toggle";
        private static final String CANCEL_EDITING = "cancel";
        private static final String START_EDITING = "startEditing";
        private static final String SELECT_ALL = "selectAll";
        private static final String CLEAR_SELECTION = "clearSelection";
        private static final String SCROLL_LEFT = "scrollLeft";
        private static final String SCROLL_RIGHT = "scrollRight";
        private static final String SCROLL_LEFT_EXTEND_SELECTION = "scrollLeftExtendSelection";
        private static final String SCROLL_RIGHT_EXTEND_SELECTION = "scrollRightExtendSelection";
        private static final String SCROLL_RIGHT_CHANGE_LEAD = "scrollRightChangeLead";
        private static final String SCROLL_LEFT_CHANGE_LEAD = "scrollLeftChangeLead";
        private static final String EXPAND = "expand";
        private static final String COLLAPSE = "collapse";
        private static final String MOVE_SELECTION_TO_PARENT = "moveSelectionToParent";
        private static final String ADD_TO_SELECTION = "addToSelection";
        private static final String TOGGLE_AND_ANCHOR = "toggleAndAnchor";
        private static final String EXTEND_TO = "extendTo";
        private static final String MOVE_SELECTION_TO = "moveSelectionTo";

        Actions() {
            super(null);
        }

        Actions(String string) {
            super(string);
        }

        @Override
        public boolean isEnabled(Object object) {
            if (object instanceof JTree && this.getName() == CANCEL_EDITING) {
                return ((JTree)object).isEditing();
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTree jTree = (JTree)actionEvent.getSource();
            BasicTreeUI basicTreeUI = (BasicTreeUI)BasicLookAndFeel.getUIOfType(jTree.getUI(), BasicTreeUI.class);
            if (basicTreeUI == null) {
                return;
            }
            String string = this.getName();
            if (string == SELECT_PREVIOUS) {
                this.increment(jTree, basicTreeUI, -1, false, true);
            } else if (string == SELECT_PREVIOUS_CHANGE_LEAD) {
                this.increment(jTree, basicTreeUI, -1, false, false);
            } else if (string == SELECT_PREVIOUS_EXTEND_SELECTION) {
                this.increment(jTree, basicTreeUI, -1, true, true);
            } else if (string == SELECT_NEXT) {
                this.increment(jTree, basicTreeUI, 1, false, true);
            } else if (string == SELECT_NEXT_CHANGE_LEAD) {
                this.increment(jTree, basicTreeUI, 1, false, false);
            } else if (string == SELECT_NEXT_EXTEND_SELECTION) {
                this.increment(jTree, basicTreeUI, 1, true, true);
            } else if (string == SELECT_CHILD) {
                this.traverse(jTree, basicTreeUI, 1, true);
            } else if (string == SELECT_CHILD_CHANGE_LEAD) {
                this.traverse(jTree, basicTreeUI, 1, false);
            } else if (string == SELECT_PARENT) {
                this.traverse(jTree, basicTreeUI, -1, true);
            } else if (string == SELECT_PARENT_CHANGE_LEAD) {
                this.traverse(jTree, basicTreeUI, -1, false);
            } else if (string == SCROLL_UP_CHANGE_SELECTION) {
                this.page(jTree, basicTreeUI, -1, false, true);
            } else if (string == SCROLL_UP_CHANGE_LEAD) {
                this.page(jTree, basicTreeUI, -1, false, false);
            } else if (string == SCROLL_UP_EXTEND_SELECTION) {
                this.page(jTree, basicTreeUI, -1, true, true);
            } else if (string == SCROLL_DOWN_CHANGE_SELECTION) {
                this.page(jTree, basicTreeUI, 1, false, true);
            } else if (string == SCROLL_DOWN_EXTEND_SELECTION) {
                this.page(jTree, basicTreeUI, 1, true, true);
            } else if (string == SCROLL_DOWN_CHANGE_LEAD) {
                this.page(jTree, basicTreeUI, 1, false, false);
            } else if (string == SELECT_FIRST) {
                this.home(jTree, basicTreeUI, -1, false, true);
            } else if (string == SELECT_FIRST_CHANGE_LEAD) {
                this.home(jTree, basicTreeUI, -1, false, false);
            } else if (string == SELECT_FIRST_EXTEND_SELECTION) {
                this.home(jTree, basicTreeUI, -1, true, true);
            } else if (string == SELECT_LAST) {
                this.home(jTree, basicTreeUI, 1, false, true);
            } else if (string == SELECT_LAST_CHANGE_LEAD) {
                this.home(jTree, basicTreeUI, 1, false, false);
            } else if (string == SELECT_LAST_EXTEND_SELECTION) {
                this.home(jTree, basicTreeUI, 1, true, true);
            } else if (string == TOGGLE) {
                this.toggle(jTree, basicTreeUI);
            } else if (string == CANCEL_EDITING) {
                this.cancelEditing(jTree, basicTreeUI);
            } else if (string == START_EDITING) {
                this.startEditing(jTree, basicTreeUI);
            } else if (string == SELECT_ALL) {
                this.selectAll(jTree, basicTreeUI, true);
            } else if (string == CLEAR_SELECTION) {
                this.selectAll(jTree, basicTreeUI, false);
            } else if (string == ADD_TO_SELECTION) {
                int n;
                if (basicTreeUI.getRowCount(jTree) > 0 && !jTree.isRowSelected(n = basicTreeUI.getLeadSelectionRow())) {
                    TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                    jTree.addSelectionRow(n);
                    basicTreeUI.setAnchorSelectionPath(treePath);
                }
            } else if (string == TOGGLE_AND_ANCHOR) {
                if (basicTreeUI.getRowCount(jTree) > 0) {
                    int n = basicTreeUI.getLeadSelectionRow();
                    TreePath treePath = basicTreeUI.getLeadSelectionPath();
                    if (!jTree.isRowSelected(n)) {
                        jTree.addSelectionRow(n);
                    } else {
                        jTree.removeSelectionRow(n);
                        basicTreeUI.setLeadSelectionPath(treePath);
                    }
                    basicTreeUI.setAnchorSelectionPath(treePath);
                }
            } else if (string == EXTEND_TO) {
                this.extendSelection(jTree, basicTreeUI);
            } else if (string == MOVE_SELECTION_TO) {
                if (basicTreeUI.getRowCount(jTree) > 0) {
                    int n = basicTreeUI.getLeadSelectionRow();
                    jTree.setSelectionInterval(n, n);
                }
            } else if (string == SCROLL_LEFT) {
                this.scroll(jTree, basicTreeUI, 0, -10);
            } else if (string == SCROLL_RIGHT) {
                this.scroll(jTree, basicTreeUI, 0, 10);
            } else if (string == SCROLL_LEFT_EXTEND_SELECTION) {
                this.scrollChangeSelection(jTree, basicTreeUI, -1, true, true);
            } else if (string == SCROLL_RIGHT_EXTEND_SELECTION) {
                this.scrollChangeSelection(jTree, basicTreeUI, 1, true, true);
            } else if (string == SCROLL_RIGHT_CHANGE_LEAD) {
                this.scrollChangeSelection(jTree, basicTreeUI, 1, false, false);
            } else if (string == SCROLL_LEFT_CHANGE_LEAD) {
                this.scrollChangeSelection(jTree, basicTreeUI, -1, false, false);
            } else if (string == EXPAND) {
                this.expand(jTree, basicTreeUI);
            } else if (string == COLLAPSE) {
                this.collapse(jTree, basicTreeUI);
            } else if (string == MOVE_SELECTION_TO_PARENT) {
                this.moveSelectionToParent(jTree, basicTreeUI);
            }
        }

        private void scrollChangeSelection(JTree jTree, BasicTreeUI basicTreeUI, int n, boolean bl, boolean bl2) {
            int n2 = basicTreeUI.getRowCount(jTree);
            if (n2 > 0 && basicTreeUI.treeSelectionModel != null) {
                TreePath treePath;
                Rectangle rectangle = jTree.getVisibleRect();
                if (n == -1) {
                    treePath = basicTreeUI.getClosestPathForLocation(jTree, rectangle.x, rectangle.y);
                    rectangle.x = Math.max(0, rectangle.x - rectangle.width);
                } else {
                    rectangle.x = Math.min(Math.max(0, jTree.getWidth() - rectangle.width), rectangle.x + rectangle.width);
                    treePath = basicTreeUI.getClosestPathForLocation(jTree, rectangle.x, rectangle.y + rectangle.height);
                }
                jTree.scrollRectToVisible(rectangle);
                if (bl) {
                    basicTreeUI.extendSelection(treePath);
                } else if (bl2) {
                    jTree.setSelectionPath(treePath);
                } else {
                    basicTreeUI.setLeadSelectionPath(treePath, true);
                }
            }
        }

        private void scroll(JTree jTree, BasicTreeUI basicTreeUI, int n, int n2) {
            Rectangle rectangle = jTree.getVisibleRect();
            Dimension dimension = jTree.getSize();
            if (n == 0) {
                rectangle.x += n2;
                rectangle.x = Math.max(0, rectangle.x);
                rectangle.x = Math.min(Math.max(0, dimension.width - rectangle.width), rectangle.x);
            } else {
                rectangle.y += n2;
                rectangle.y = Math.max(0, rectangle.y);
                rectangle.y = Math.min(Math.max(0, dimension.width - rectangle.height), rectangle.y);
            }
            jTree.scrollRectToVisible(rectangle);
        }

        private void extendSelection(JTree jTree, BasicTreeUI basicTreeUI) {
            int n;
            if (basicTreeUI.getRowCount(jTree) > 0 && (n = basicTreeUI.getLeadSelectionRow()) != -1) {
                TreePath treePath = basicTreeUI.getLeadSelectionPath();
                TreePath treePath2 = basicTreeUI.getAnchorSelectionPath();
                int n2 = basicTreeUI.getRowForPath(jTree, treePath2);
                if (n2 == -1) {
                    n2 = 0;
                }
                jTree.setSelectionInterval(n2, n);
                basicTreeUI.setLeadSelectionPath(treePath);
                basicTreeUI.setAnchorSelectionPath(treePath2);
            }
        }

        private void selectAll(JTree jTree, BasicTreeUI basicTreeUI, boolean bl) {
            int n = basicTreeUI.getRowCount(jTree);
            if (n > 0) {
                if (bl) {
                    if (jTree.getSelectionModel().getSelectionMode() == 1) {
                        int n2 = basicTreeUI.getLeadSelectionRow();
                        if (n2 != -1) {
                            jTree.setSelectionRow(n2);
                        } else if (jTree.getMinSelectionRow() == -1) {
                            jTree.setSelectionRow(0);
                            basicTreeUI.ensureRowsAreVisible(0, 0);
                        }
                        return;
                    }
                    TreePath treePath = basicTreeUI.getLeadSelectionPath();
                    TreePath treePath2 = basicTreeUI.getAnchorSelectionPath();
                    if (treePath != null && !jTree.isVisible(treePath)) {
                        treePath = null;
                    }
                    jTree.setSelectionInterval(0, n - 1);
                    if (treePath != null) {
                        basicTreeUI.setLeadSelectionPath(treePath);
                    }
                    if (treePath2 != null && jTree.isVisible(treePath2)) {
                        basicTreeUI.setAnchorSelectionPath(treePath2);
                    }
                } else {
                    TreePath treePath = basicTreeUI.getLeadSelectionPath();
                    TreePath treePath3 = basicTreeUI.getAnchorSelectionPath();
                    jTree.clearSelection();
                    basicTreeUI.setAnchorSelectionPath(treePath3);
                    basicTreeUI.setLeadSelectionPath(treePath);
                }
            }
        }

        private void startEditing(JTree jTree, BasicTreeUI basicTreeUI) {
            int n;
            TreePath treePath = basicTreeUI.getLeadSelectionPath();
            int n2 = n = treePath != null ? basicTreeUI.getRowForPath(jTree, treePath) : -1;
            if (n != -1) {
                jTree.startEditingAtPath(treePath);
            }
        }

        private void cancelEditing(JTree jTree, BasicTreeUI basicTreeUI) {
            jTree.cancelEditing();
        }

        private void toggle(JTree jTree, BasicTreeUI basicTreeUI) {
            int n = basicTreeUI.getLeadSelectionRow();
            if (n != -1 && !basicTreeUI.isLeaf(n)) {
                TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                TreePath treePath2 = basicTreeUI.getLeadSelectionPath();
                basicTreeUI.toggleExpandState(basicTreeUI.getPathForRow(jTree, n));
                basicTreeUI.setAnchorSelectionPath(treePath);
                basicTreeUI.setLeadSelectionPath(treePath2);
            }
        }

        private void expand(JTree jTree, BasicTreeUI basicTreeUI) {
            int n = basicTreeUI.getLeadSelectionRow();
            jTree.expandRow(n);
        }

        private void collapse(JTree jTree, BasicTreeUI basicTreeUI) {
            int n = basicTreeUI.getLeadSelectionRow();
            jTree.collapseRow(n);
        }

        private void increment(JTree jTree, BasicTreeUI basicTreeUI, int n, boolean bl, boolean bl2) {
            int n2;
            if (!bl && !bl2 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl2 = true;
            }
            if (basicTreeUI.treeSelectionModel != null && (n2 = jTree.getRowCount()) > 0) {
                int n3 = basicTreeUI.getLeadSelectionRow();
                int n4 = n3 == -1 ? (n == 1 ? 0 : n2 - 1) : Math.min(n2 - 1, Math.max(0, n3 + n));
                if (bl && basicTreeUI.treeSelectionModel.getSelectionMode() != 1) {
                    basicTreeUI.extendSelection(jTree.getPathForRow(n4));
                } else if (bl2) {
                    jTree.setSelectionInterval(n4, n4);
                } else {
                    basicTreeUI.setLeadSelectionPath(jTree.getPathForRow(n4), true);
                }
                basicTreeUI.ensureRowsAreVisible(n4, n4);
                basicTreeUI.lastSelectedRow = n4;
            }
        }

        private void traverse(JTree jTree, BasicTreeUI basicTreeUI, int n, boolean bl) {
            int n2;
            if (!bl && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl = true;
            }
            if ((n2 = jTree.getRowCount()) > 0) {
                int n3;
                int n4 = basicTreeUI.getLeadSelectionRow();
                if (n4 == -1) {
                    n3 = 0;
                } else if (n == 1) {
                    TreePath treePath = basicTreeUI.getPathForRow(jTree, n4);
                    int n5 = jTree.getModel().getChildCount(treePath.getLastPathComponent());
                    n3 = -1;
                    if (!basicTreeUI.isLeaf(n4)) {
                        if (!jTree.isExpanded(n4)) {
                            basicTreeUI.toggleExpandState(treePath);
                        } else if (n5 > 0) {
                            n3 = Math.min(n4 + 1, n2 - 1);
                        }
                    }
                } else if (!basicTreeUI.isLeaf(n4) && jTree.isExpanded(n4)) {
                    basicTreeUI.toggleExpandState(basicTreeUI.getPathForRow(jTree, n4));
                    n3 = -1;
                } else {
                    TreePath treePath = basicTreeUI.getPathForRow(jTree, n4);
                    n3 = treePath != null && treePath.getPathCount() > 1 ? basicTreeUI.getRowForPath(jTree, treePath.getParentPath()) : -1;
                }
                if (n3 != -1) {
                    if (bl) {
                        jTree.setSelectionInterval(n3, n3);
                    } else {
                        basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, n3), true);
                    }
                    basicTreeUI.ensureRowsAreVisible(n3, n3);
                }
            }
        }

        private void moveSelectionToParent(JTree jTree, BasicTreeUI basicTreeUI) {
            int n;
            int n2 = basicTreeUI.getLeadSelectionRow();
            TreePath treePath = basicTreeUI.getPathForRow(jTree, n2);
            if (treePath != null && treePath.getPathCount() > 1 && (n = basicTreeUI.getRowForPath(jTree, treePath.getParentPath())) != -1) {
                jTree.setSelectionInterval(n, n);
                basicTreeUI.ensureRowsAreVisible(n, n);
            }
        }

        private void page(JTree jTree, BasicTreeUI basicTreeUI, int n, boolean bl, boolean bl2) {
            int n2;
            if (!bl && !bl2 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl2 = true;
            }
            if ((n2 = basicTreeUI.getRowCount(jTree)) > 0 && basicTreeUI.treeSelectionModel != null) {
                Rectangle rectangle;
                TreePath treePath;
                Dimension dimension = jTree.getSize();
                TreePath treePath2 = basicTreeUI.getLeadSelectionPath();
                Rectangle rectangle2 = jTree.getVisibleRect();
                if (n == -1) {
                    treePath = basicTreeUI.getClosestPathForLocation(jTree, rectangle2.x, rectangle2.y);
                    if (treePath.equals(treePath2)) {
                        rectangle2.y = Math.max(0, rectangle2.y - rectangle2.height);
                        treePath = jTree.getClosestPathForLocation(rectangle2.x, rectangle2.y);
                    }
                } else {
                    rectangle2.y = Math.min(dimension.height, rectangle2.y + rectangle2.height - 1);
                    treePath = jTree.getClosestPathForLocation(rectangle2.x, rectangle2.y);
                    if (treePath.equals(treePath2)) {
                        rectangle2.y = Math.min(dimension.height, rectangle2.y + rectangle2.height - 1);
                        treePath = jTree.getClosestPathForLocation(rectangle2.x, rectangle2.y);
                    }
                }
                if ((rectangle = basicTreeUI.getPathBounds(jTree, treePath)) != null) {
                    rectangle.x = rectangle2.x;
                    rectangle.width = rectangle2.width;
                    if (n == -1) {
                        rectangle.height = rectangle2.height;
                    } else {
                        rectangle.y -= rectangle2.height - rectangle.height;
                        rectangle.height = rectangle2.height;
                    }
                    if (bl) {
                        basicTreeUI.extendSelection(treePath);
                    } else if (bl2) {
                        jTree.setSelectionPath(treePath);
                    } else {
                        basicTreeUI.setLeadSelectionPath(treePath, true);
                    }
                    jTree.scrollRectToVisible(rectangle);
                }
            }
        }

        private void home(JTree jTree, final BasicTreeUI basicTreeUI, int n, boolean bl, boolean bl2) {
            int n2;
            if (!bl && !bl2 && jTree.getSelectionModel().getSelectionMode() != 4) {
                bl2 = true;
            }
            if ((n2 = basicTreeUI.getRowCount(jTree)) > 0) {
                if (n == -1) {
                    basicTreeUI.ensureRowsAreVisible(0, 0);
                    if (bl) {
                        int n3;
                        TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                        int n4 = n3 = treePath == null ? -1 : basicTreeUI.getRowForPath(jTree, treePath);
                        if (n3 == -1) {
                            jTree.setSelectionInterval(0, 0);
                        } else {
                            jTree.setSelectionInterval(0, n3);
                            basicTreeUI.setAnchorSelectionPath(treePath);
                            basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, 0));
                        }
                    } else if (bl2) {
                        jTree.setSelectionInterval(0, 0);
                    } else {
                        basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, 0), true);
                    }
                } else {
                    basicTreeUI.ensureRowsAreVisible(n2 - 1, n2 - 1);
                    if (bl) {
                        int n5;
                        TreePath treePath = basicTreeUI.getAnchorSelectionPath();
                        int n6 = n5 = treePath == null ? -1 : basicTreeUI.getRowForPath(jTree, treePath);
                        if (n5 == -1) {
                            jTree.setSelectionInterval(n2 - 1, n2 - 1);
                        } else {
                            jTree.setSelectionInterval(n5, n2 - 1);
                            basicTreeUI.setAnchorSelectionPath(treePath);
                            basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, n2 - 1));
                        }
                    } else if (bl2) {
                        jTree.setSelectionInterval(n2 - 1, n2 - 1);
                    } else {
                        basicTreeUI.setLeadSelectionPath(basicTreeUI.getPathForRow(jTree, n2 - 1), true);
                    }
                    if (basicTreeUI.isLargeModel()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                basicTreeUI.ensureRowsAreVisible(n2 - 1, n2 - 1);
                            }
                        });
                    }
                }
            }
        }
    }

    private class Handler
    implements CellEditorListener,
    FocusListener,
    KeyListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeModelListener,
    TreeSelectionListener,
    DragRecognitionSupport.BeforeDrag {
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private boolean dragPressDidSelection;
        private boolean dragStarted;
        private TreePath pressedPath;
        private MouseEvent pressedEvent;
        private boolean valueChangedOnPress;

        private Handler() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.getRowCount() > 0 && BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                TreePath treePath;
                if (keyEvent.isAltDown() || BasicGraphicsUtils.isMenuShortcutKeyDown(keyEvent) || this.isNavigationKey(keyEvent)) {
                    return;
                }
                boolean bl = true;
                char c = keyEvent.getKeyChar();
                long l = keyEvent.getWhen();
                int n = BasicTreeUI.this.tree.getLeadSelectionRow();
                if (l - this.lastTime < BasicTreeUI.this.timeFactor) {
                    this.typedString = this.typedString + c;
                    if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                        ++n;
                    } else {
                        this.prefix = this.typedString;
                    }
                } else {
                    ++n;
                    this.prefix = this.typedString = "" + c;
                }
                this.lastTime = l;
                if (n < 0 || n >= BasicTreeUI.this.tree.getRowCount()) {
                    bl = false;
                    n = 0;
                }
                if ((treePath = BasicTreeUI.this.tree.getNextMatch(this.prefix, n, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                    int n2 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                    BasicTreeUI.this.ensureRowsAreVisible(n2, n2);
                } else if (bl && (treePath = BasicTreeUI.this.tree.getNextMatch(this.prefix, 0, Position.Bias.Forward)) != null) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                    int n3 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                    BasicTreeUI.this.ensureRowsAreVisible(n3, n3);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (BasicTreeUI.this.tree != null && this.isNavigationKey(keyEvent)) {
                this.prefix = "";
                this.typedString = "";
                this.lastTime = 0L;
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        private boolean isNavigationKey(KeyEvent keyEvent) {
            InputMap inputMap = BasicTreeUI.this.tree.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            return inputMap != null && inputMap.get(keyStroke) != null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicTreeUI.this.treeSelectionModel) {
                BasicTreeUI.this.treeSelectionModel.resetRowSelection();
            } else if (propertyChangeEvent.getSource() == BasicTreeUI.this.tree) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == "leadSelectionPath") {
                    if (!BasicTreeUI.this.ignoreLAChange) {
                        BasicTreeUI.this.updateLeadSelectionRow();
                        BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                        BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
                    }
                } else if (string == "anchorSelectionPath" && !BasicTreeUI.this.ignoreLAChange) {
                    BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getOldValue());
                    BasicTreeUI.this.repaintPath((TreePath)propertyChangeEvent.getNewValue());
                }
                if (string == "cellRenderer") {
                    BasicTreeUI.this.setCellRenderer((TreeCellRenderer)propertyChangeEvent.getNewValue());
                    BasicTreeUI.this.redoTheLayout();
                } else if (string == "model") {
                    BasicTreeUI.this.setModel((TreeModel)propertyChangeEvent.getNewValue());
                } else if (string == "rootVisible") {
                    BasicTreeUI.this.setRootVisible((Boolean)propertyChangeEvent.getNewValue());
                } else if (string == "showsRootHandles") {
                    BasicTreeUI.this.setShowsRootHandles((Boolean)propertyChangeEvent.getNewValue());
                } else if (string == "rowHeight") {
                    BasicTreeUI.this.setRowHeight((Integer)propertyChangeEvent.getNewValue());
                } else if (string == "cellEditor") {
                    BasicTreeUI.this.setCellEditor((TreeCellEditor)propertyChangeEvent.getNewValue());
                } else if (string == "editable") {
                    BasicTreeUI.this.setEditable((Boolean)propertyChangeEvent.getNewValue());
                } else if (string == "largeModel") {
                    BasicTreeUI.this.setLargeModel(BasicTreeUI.this.tree.isLargeModel());
                } else if (string == "selectionModel") {
                    BasicTreeUI.this.setSelectionModel(BasicTreeUI.this.tree.getSelectionModel());
                } else if (string == "font") {
                    BasicTreeUI.this.completeEditing();
                    if (BasicTreeUI.this.treeState != null) {
                        BasicTreeUI.this.treeState.invalidateSizes();
                    }
                    BasicTreeUI.this.updateSize();
                } else if (string == "componentOrientation") {
                    if (BasicTreeUI.this.tree != null) {
                        BasicTreeUI.this.leftToRight = BasicGraphicsUtils.isLeftToRight(BasicTreeUI.this.tree);
                        BasicTreeUI.this.redoTheLayout();
                        BasicTreeUI.this.tree.treeDidChange();
                        InputMap inputMap = BasicTreeUI.this.getInputMap(0);
                        SwingUtilities.replaceUIInputMap(BasicTreeUI.this.tree, 0, inputMap);
                    }
                } else if ("dropLocation" == string) {
                    JTree.DropLocation dropLocation = (JTree.DropLocation)propertyChangeEvent.getOldValue();
                    this.repaintDropLocation(dropLocation);
                    this.repaintDropLocation(BasicTreeUI.this.tree.getDropLocation());
                }
            }
        }

        private void repaintDropLocation(JTree.DropLocation dropLocation) {
            if (dropLocation == null) {
                return;
            }
            Rectangle rectangle = BasicTreeUI.this.isDropLine(dropLocation) ? BasicTreeUI.this.getDropLineRect(dropLocation) : BasicTreeUI.this.tree.getPathBounds(dropLocation.getPath());
            if (rectangle != null) {
                BasicTreeUI.this.tree.repaint(rectangle);
            }
        }

        private boolean isActualPath(TreePath treePath, int n, int n2) {
            if (treePath == null) {
                return false;
            }
            Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
            if (rectangle == null || n2 > rectangle.y + rectangle.height) {
                return false;
            }
            return n >= rectangle.x && n <= rectangle.x + rectangle.width;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.isEditing(BasicTreeUI.this.tree) && BasicTreeUI.this.tree.getInvokesStopCellEditing() && !BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree)) {
                return;
            }
            BasicTreeUI.this.completeEditing();
            this.pressedPath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY());
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                this.mousePressedDND(mouseEvent);
            } else {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
                this.handleSelection(mouseEvent);
            }
        }

        private void mousePressedDND(MouseEvent mouseEvent) {
            this.pressedEvent = mouseEvent;
            boolean bl = true;
            this.dragStarted = false;
            this.valueChangedOnPress = false;
            if (this.isActualPath(this.pressedPath, mouseEvent.getX(), mouseEvent.getY()) && DragRecognitionSupport.mousePressed(mouseEvent)) {
                this.dragPressDidSelection = false;
                if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                    return;
                }
                if (!mouseEvent.isShiftDown() && BasicTreeUI.this.tree.isPathSelected(this.pressedPath)) {
                    BasicTreeUI.this.setAnchorSelectionPath(this.pressedPath);
                    BasicTreeUI.this.setLeadSelectionPath(this.pressedPath, true);
                    return;
                }
                this.dragPressDidSelection = true;
                bl = false;
            }
            if (bl) {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
            }
            this.handleSelection(mouseEvent);
        }

        void handleSelection(MouseEvent mouseEvent) {
            if (this.pressedPath != null) {
                int n;
                Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, this.pressedPath);
                if (rectangle == null || mouseEvent.getY() >= rectangle.y + rectangle.height) {
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    BasicTreeUI.this.checkForClickInExpandControl(this.pressedPath, mouseEvent.getX(), mouseEvent.getY());
                }
                if ((n = mouseEvent.getX()) >= rectangle.x && n < rectangle.x + rectangle.width && (BasicTreeUI.this.tree.getDragEnabled() || !BasicTreeUI.this.startEditing(this.pressedPath, mouseEvent))) {
                    BasicTreeUI.this.selectPathForEvent(this.pressedPath, mouseEvent);
                }
            }
        }

        @Override
        public void dragStarting(MouseEvent mouseEvent) {
            this.dragStarted = true;
            if (BasicGraphicsUtils.isMenuShortcutKeyDown(mouseEvent)) {
                BasicTreeUI.this.tree.addSelectionPath(this.pressedPath);
                BasicTreeUI.this.setAnchorSelectionPath(this.pressedPath);
                BasicTreeUI.this.setLeadSelectionPath(this.pressedPath, true);
            }
            this.pressedEvent = null;
            this.pressedPath = null;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                DragRecognitionSupport.mouseDragged(mouseEvent, this);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities2.shouldIgnore(mouseEvent, BasicTreeUI.this.tree)) {
                return;
            }
            if (BasicTreeUI.this.tree.getDragEnabled()) {
                this.mouseReleasedDND(mouseEvent);
            }
            this.pressedEvent = null;
            this.pressedPath = null;
        }

        private void mouseReleasedDND(MouseEvent mouseEvent) {
            MouseEvent mouseEvent2 = DragRecognitionSupport.mouseReleased(mouseEvent);
            if (mouseEvent2 != null) {
                SwingUtilities2.adjustFocus(BasicTreeUI.this.tree);
                if (!this.dragPressDidSelection) {
                    this.handleSelection(mouseEvent2);
                }
            }
            if (!this.dragStarted && this.pressedPath != null && !this.valueChangedOnPress && this.isActualPath(this.pressedPath, this.pressedEvent.getX(), this.pressedEvent.getY())) {
                BasicTreeUI.this.startEditingOnRelease(this.pressedPath, this.pressedEvent, mouseEvent);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (BasicTreeUI.this.tree != null) {
                Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.tree.getLeadSelectionPath());
                if (rectangle != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getRepaintPathBounds(rectangle));
                }
                if ((rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, BasicTreeUI.this.getLeadSelectionPath())) != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getRepaintPathBounds(rectangle));
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Object object;
            TreePath[] treePathArray;
            this.valueChangedOnPress = true;
            BasicTreeUI.this.completeEditing();
            if (BasicTreeUI.this.tree.getExpandsSelectedPaths() && BasicTreeUI.this.treeSelectionModel != null && (treePathArray = BasicTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                for (int i = treePathArray.length - 1; i >= 0; --i) {
                    object = treePathArray[i].getParentPath();
                    boolean bl = true;
                    while (object != null) {
                        if (BasicTreeUI.this.treeModel.isLeaf(object.getLastPathComponent())) {
                            bl = false;
                            object = null;
                            continue;
                        }
                        object = object.getParentPath();
                    }
                    if (!bl) continue;
                    BasicTreeUI.this.tree.makeVisible(treePathArray[i]);
                }
            }
            treePathArray = BasicTreeUI.this.getLeadSelectionPath();
            BasicTreeUI.this.lastSelectedRow = BasicTreeUI.this.tree.getMinSelectionRow();
            TreePath treePath = BasicTreeUI.this.tree.getSelectionModel().getLeadSelectionPath();
            BasicTreeUI.this.setAnchorSelectionPath(treePath);
            BasicTreeUI.this.setLeadSelectionPath(treePath);
            object = treeSelectionEvent.getPaths();
            Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
            boolean bl = true;
            int n = BasicTreeUI.this.tree.getWidth();
            if (object != null) {
                int n2 = ((TreePath[])object).length;
                if (n2 > 4) {
                    BasicTreeUI.this.tree.repaint();
                    bl = false;
                } else {
                    for (int i = 0; i < n2; ++i) {
                        Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, object[i]);
                        if (rectangle2 == null || !rectangle.intersects(rectangle2)) continue;
                        BasicTreeUI.this.tree.repaint(0, rectangle2.y, n, rectangle2.height);
                    }
                }
            }
            if (bl) {
                Rectangle rectangle3 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, (TreePath)treePathArray);
                if (rectangle3 != null && rectangle.intersects(rectangle3)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle3.y, n, rectangle3.height);
                }
                if ((rectangle3 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath)) != null && rectangle.intersects(rectangle3)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle3.y, n, rectangle3.height);
                }
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.updateExpandedDescendants(treePath);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.completeEditing();
                if (treePath != null && BasicTreeUI.this.tree.isVisible(treePath)) {
                    BasicTreeUI.this.treeState.setExpandedState(treePath, false);
                    BasicTreeUI.this.updateLeadSelectionRow();
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                TreePath treePath = treeModelEvent.getTreePath();
                int[] nArray = treeModelEvent.getChildIndices();
                if (nArray == null || nArray.length == 0) {
                    BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
                    BasicTreeUI.this.updateSize();
                } else if (BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    int n = nArray[0];
                    for (int i = nArray.length - 1; i > 0; --i) {
                        n = Math.min(nArray[i], n);
                    }
                    Object object = BasicTreeUI.this.treeModel.getChild(treePath.getLastPathComponent(), n);
                    TreePath treePath2 = treePath.pathByAddingChild(object);
                    Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath2);
                    BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
                    BasicTreeUI.this.updateSize0();
                    Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath2);
                    if (rectangle == null || rectangle2 == null) {
                        return;
                    }
                    if (nArray.length == 1 && rectangle2.height == rectangle.height) {
                        BasicTreeUI.this.tree.repaint(0, rectangle.y, BasicTreeUI.this.tree.getWidth(), rectangle.height);
                    } else {
                        BasicTreeUI.this.tree.repaint(0, rectangle.y, BasicTreeUI.this.tree.getWidth(), BasicTreeUI.this.tree.getHeight() - rectangle.y);
                    }
                } else {
                    BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
                }
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesInserted(treeModelEvent);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                } else {
                    int[] nArray = treeModelEvent.getChildIndices();
                    int n = BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent());
                    if (nArray != null && n - nArray.length == 0) {
                        BasicTreeUI.this.updateSize();
                    }
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesRemoved(treeModelEvent);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath) || BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent()) == 0) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeStructureChanged(treeModelEvent);
                BasicTreeUI.this.updateLeadSelectionRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (treePath != null) {
                    treePath = treePath.getParentPath();
                }
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }

    static class TreeTransferHandler
    extends TransferHandler
    implements UIResource,
    Comparator<TreePath> {
        private JTree tree;

        TreeTransferHandler() {
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTree) {
                TreePath[] treePathArray;
                this.tree = (JTree)jComponent;
                TreePath[] treePathArray2 = this.tree.getSelectionPaths();
                if (treePathArray2 == null || treePathArray2.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<ul>\n");
                TreeModel treeModel = this.tree.getModel();
                Object var6_6 = null;
                for (TreePath treePath : treePathArray = this.getDisplayOrderPaths(treePathArray2)) {
                    Object object = treePath.getLastPathComponent();
                    boolean bl = treeModel.isLeaf(object);
                    String string = this.getDisplayString(treePath, true, bl);
                    stringBuffer.append(string + "\n");
                    stringBuffer2.append("  <li>" + string + "\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</ul>\n</body>\n</html>");
                this.tree = null;
                return new BasicTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }

        @Override
        public int compare(TreePath treePath, TreePath treePath2) {
            int n = this.tree.getRowForPath(treePath);
            int n2 = this.tree.getRowForPath(treePath2);
            return n - n2;
        }

        String getDisplayString(TreePath treePath, boolean bl, boolean bl2) {
            int n = this.tree.getRowForPath(treePath);
            boolean bl3 = this.tree.getLeadSelectionRow() == n;
            Object object = treePath.getLastPathComponent();
            return this.tree.convertValueToText(object, bl, this.tree.isExpanded(n), bl2, n, bl3);
        }

        TreePath[] getDisplayOrderPaths(TreePath[] treePathArray) {
            int n;
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            TreePath[] treePathArray2 = treePathArray;
            int n2 = treePathArray2.length;
            for (n = 0; n < n2; ++n) {
                TreePath treePath = treePathArray2[n];
                arrayList.add(treePath);
            }
            Collections.sort(arrayList, this);
            int n3 = arrayList.size();
            TreePath[] treePathArray3 = new TreePath[n3];
            for (n = 0; n < n3; ++n) {
                treePathArray3[n] = (TreePath)arrayList.get(n);
            }
            return treePathArray3;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 1;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;
        private Component focusComponent;
        private boolean dispatchedEvent;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this(component, component2, mouseEvent, null);
        }

        MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent, Component component3) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            SwingUtilities2.setSkipClickCount(component2, mouseEvent.getClickCount() - 1);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
            this.focusComponent = component3;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.dispatchedEvent = true;
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.removeFromSource();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.dispatchedEvent = true;
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
                if (this.focusComponent != null && this.focusComponent == this.destination && !this.dispatchedEvent && this.focusComponent instanceof JTextField) {
                    ((JTextField)this.focusComponent).selectAll();
                }
            }
            this.destination = null;
            this.source = null;
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String string) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.cancelEditing(BasicTreeUI.this.tree, BasicTreeUI.this);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled() && BasicTreeUI.this.isEditing(BasicTreeUI.this.tree);
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String string) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.toggle(BasicTreeUI.this.tree, BasicTreeUI.this);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreeHomeAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.changeSelection = bl2;
            this.addToSelection = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.home(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreeIncrementAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.increment(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreePageAction(int n, String string, boolean bl, boolean bl2) {
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.page(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.addToSelection, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int n, String string) {
            this(n, string, true);
        }

        private TreeTraverseAction(int n, String string, boolean bl) {
            this.direction = n;
            this.changeSelection = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                SHARED_ACTION.traverse(BasicTreeUI.this.tree, BasicTreeUI.this, this.direction, this.changeSelection);
            }
        }

        @Override
        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTreeUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicTreeUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mousePressed(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mouseDragged(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mouseMoved(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            BasicTreeUI.this.getHandler().mouseReleased(mouseEvent);
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        @Override
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == n) {
                Dimension dimension = BasicTreeUI.this.editingComponent.getPreferredSize();
                int n3 = BasicTreeUI.this.getRowHeight();
                if (n3 > 0 && n3 != dimension.height) {
                    dimension.height = n3;
                }
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            if (BasicTreeUI.this.currentCellRenderer != null) {
                Component component = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, object, BasicTreeUI.this.tree.isRowSelected(n), bl, BasicTreeUI.this.treeModel.isLeaf(object), n, false);
                if (BasicTreeUI.this.tree != null) {
                    BasicTreeUI.this.rendererPane.add(component);
                    component.validate();
                }
                Dimension dimension = component.getPreferredSize();
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            return null;
        }

        protected int getRowX(int n, int n2) {
            return BasicTreeUI.this.getRowX(n, n2);
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicTreeUI.this.getHandler().focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicTreeUI.this.getHandler().focusLost(focusEvent);
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            BasicTreeUI.this.getHandler().keyTyped(keyEvent);
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            BasicTreeUI.this.getHandler().keyPressed(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            BasicTreeUI.this.getHandler().keyReleased(keyEvent);
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.getHandler().editingStopped(changeEvent);
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.getHandler().editingCanceled(changeEvent);
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            BasicTreeUI.this.getHandler().valueChanged(treeSelectionEvent);
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeNodesChanged(treeModelEvent);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeNodesInserted(treeModelEvent);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeNodesRemoved(treeModelEvent);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.getHandler().treeStructureChanged(treeModelEvent);
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        protected JScrollPane getScrollPane() {
            Container container;
            for (container = BasicTreeUI.this.tree.getParent(); container != null && !(container instanceof JScrollPane); container = container.getParent()) {
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.getHandler().treeExpanded(treeExpansionEvent);
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.getHandler().treeCollapsed(treeExpansionEvent);
        }
    }
}

