/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.FileDialog;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import sun.awt.AWTAccessor;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XToolkit;

class GtkFileDialogPeer
extends XDialogPeer
implements FileDialogPeer {
    private FileDialog fd;
    private volatile long widget = 0L;

    public GtkFileDialogPeer(FileDialog fileDialog) {
        super(fileDialog);
        this.fd = fileDialog;
    }

    private static native void initIDs();

    private native void run(String var1, int var2, String var3, String var4, FilenameFilter var5, boolean var6, int var7, int var8);

    private native void quit();

    @Override
    public native void toFront();

    @Override
    public native void setBounds(int var1, int var2, int var3, int var4, int var5);

    private void setFileInternal(String string, String[] stringArray) {
        AWTAccessor.FileDialogAccessor fileDialogAccessor = AWTAccessor.getFileDialogAccessor();
        if (stringArray == null) {
            fileDialogAccessor.setDirectory(this.fd, null);
            fileDialogAccessor.setFile(this.fd, null);
            fileDialogAccessor.setFiles(this.fd, null);
        } else {
            String string2 = string;
            if (string != null) {
                string2 = string.endsWith(File.separator) ? string : string + File.separator;
            }
            fileDialogAccessor.setDirectory(this.fd, string2);
            fileDialogAccessor.setFile(this.fd, stringArray[0]);
            int n = stringArray != null ? stringArray.length : 0;
            File[] fileArray = new File[n];
            for (int i = 0; i < n; ++i) {
                fileArray[i] = new File(string, stringArray[i]);
            }
            fileDialogAccessor.setFiles(this.fd, fileArray);
        }
    }

    private boolean filenameFilterCallback(String string) {
        if (this.fd.getFilenameFilter() == null) {
            return true;
        }
        File file = new File(string);
        return this.fd.getFilenameFilter().accept(new File(file.getParent()), file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean bl) {
        XToolkit.awtLock();
        try {
            if (bl) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        GtkFileDialogPeer.this.showNativeDialog();
                        GtkFileDialogPeer.this.fd.setVisible(false);
                    }
                };
                thread.start();
            } else {
                this.quit();
                this.fd.setVisible(false);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void dispose() {
        this.quit();
        super.dispose();
    }

    @Override
    public void setDirectory(String string) {
    }

    @Override
    public void setFile(String string) {
    }

    @Override
    public void setFilenameFilter(FilenameFilter filenameFilter) {
    }

    private void showNativeDialog() {
        String string = this.fd.getDirectory();
        String string2 = this.fd.getFile();
        if (string2 != null) {
            File file = new File(string2);
            if (this.fd.getMode() == 0 && string != null && file.getParent() == null) {
                string2 = string + (string.endsWith(File.separator) ? "" : File.separator) + string2;
            }
            if (this.fd.getMode() == 1 && file.getParent() != null) {
                string2 = file.getName();
                string = file.getParent();
            }
        }
        this.run(this.fd.getTitle(), this.fd.getMode(), string, string2, this.fd.getFilenameFilter(), this.fd.isMultipleMode(), this.fd.getX(), this.fd.getY());
    }

    static {
        GtkFileDialogPeer.initIDs();
    }
}

