/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XIMHotKeyTrigger
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 12 : 16;
    }

    @Override
    public int getDataSize() {
        return XIMHotKeyTrigger.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XIMHotKeyTrigger(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XIMHotKeyTrigger() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XIMHotKeyTrigger.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public long get_keysym() {
        log.finest("");
        return Native.getLong(this.pData + 0L);
    }

    public void set_keysym(long l) {
        log.finest("");
        Native.putLong(this.pData + 0L, l);
    }

    public int get_modifier() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_modifier(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), n);
    }

    public int get_modifier_mask() {
        log.finest("");
        return Native.getInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12));
    }

    public void set_modifier_mask(int n) {
        log.finest("");
        Native.putInt(this.pData + (long)(XlibWrapper.dataModel == 32 ? 8 : 12), n);
    }

    @Override
    String getName() {
        return "XIMHotKeyTrigger";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(120);
        stringBuilder.append("keysym = ").append(this.get_keysym()).append(", ");
        stringBuilder.append("modifier = ").append(this.get_modifier()).append(", ");
        stringBuilder.append("modifier_mask = ").append(this.get_modifier_mask()).append(", ");
        return stringBuilder.toString();
    }
}

