/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Image;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.SunToolkit;
import sun.lwawt.LWToolkit;
import sun.lwawt.macosx.CImage;
import sun.lwawt.macosx.CMenuComponent;
import sun.lwawt.macosx.CThreading;

public class CMenuItem
extends CMenuComponent
implements MenuItemPeer {
    private final AtomicBoolean enabled = new AtomicBoolean(true);

    public CMenuItem(MenuItem menuItem) {
        super(menuItem);
        this.initialize(menuItem);
    }

    protected void initialize(MenuItem menuItem) {
        if (!this.isSeparator()) {
            this.setLabel(menuItem.getLabel());
            this.setEnabled(menuItem.isEnabled());
        }
    }

    private boolean isSeparator() {
        String string = ((MenuItem)this.getTarget()).getLabel();
        return string != null && string.equals("-");
    }

    @Override
    protected long createModel() {
        CMenuComponent cMenuComponent = (CMenuComponent)LWToolkit.targetToPeer(this.getTarget().getParent());
        return this.nativeCreate(cMenuComponent.getModel(), this.isSeparator());
    }

    public void setLabel(String string, char c, int n, int n2) {
        MenuShortcut menuShortcut;
        int n3 = n2;
        if (n == 0 && (menuShortcut = ((MenuItem)this.getTarget()).getShortcut()) != null) {
            n = menuShortcut.getKey();
            n3 |= 4;
            if (menuShortcut.usesShiftModifier()) {
                n3 |= 1;
            }
        }
        if (string == null) {
            string = "";
        }
        if (c == '\uffff') {
            c = '\u0000';
        }
        this.nativeSetLabel(this.getModel(), string, c, n, n3);
    }

    @Override
    public void setLabel(String string) {
        this.setLabel(string, '\u0000', 0, 0);
    }

    public void setImage(Image image) {
        CImage cImage = CImage.getCreator().createFromImage(image);
        this.nativeSetImage(this.getModel(), cImage == null ? 0L : cImage.ptr);
    }

    public void setToolTipText(String string) {
        this.nativeSetTooltip(this.getModel(), string);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public final boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean bl) {
        Object object = LWToolkit.targetToPeer(this.getTarget().getParent());
        if (object instanceof CMenuItem) {
            bl &= ((CMenuItem)object).isEnabled();
        }
        if (this.enabled.compareAndSet(!bl, bl)) {
            this.nativeSetEnabled(this.getModel(), bl);
        }
    }

    private native long nativeCreate(long var1, boolean var3);

    private native void nativeSetLabel(long var1, String var3, char var4, int var5, int var6);

    private native void nativeSetImage(long var1, long var3);

    private native void nativeSetTooltip(long var1, String var3);

    private native void nativeSetEnabled(long var1, boolean var3);

    void handleAction(final long l, final int n) {
        assert (CThreading.assertAppKit());
        SunToolkit.executeOnEventHandlerThread(this.getTarget(), new Runnable(){

            @Override
            public void run() {
                String string = ((MenuItem)CMenuItem.this.getTarget()).getActionCommand();
                ActionEvent actionEvent = new ActionEvent(CMenuItem.this.getTarget(), 1001, string, l, n);
                SunToolkit.postEvent(SunToolkit.targetToAppContext(CMenuItem.this.getTarget()), actionEvent);
            }
        });
    }
}

