/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

final class HTMLSupport {
    public static final String ENCODING = "UTF-8";
    public static final String VERSION = "Version:";
    public static final String START_HTML = "StartHTML:";
    public static final String END_HTML = "EndHTML:";
    public static final String START_FRAGMENT = "StartFragment:";
    public static final String END_FRAGMENT = "EndFragment:";
    public static final String START_FRAGMENT_CMT = "<!--StartFragment-->";
    public static final String END_FRAGMENT_CMT = "<!--EndFragment-->";
    public static final String EOLN = "\r\n";
    private static final String VERSION_NUM = "0.9";
    private static final String HTML_START_END = "-1";
    private static final int PADDED_WIDTH = 10;
    private static final int HEADER_LEN = "Version:".length() + "0.9".length() + "\r\n".length() + "StartHTML:".length() + "-1".length() + "\r\n".length() + "EndHTML:".length() + "-1".length() + "\r\n".length() + "StartFragment:".length() + 10 + "\r\n".length() + "EndFragment:".length() + 10 + "\r\n".length() + "<!--StartFragment-->".length() + "\r\n".length();
    private static final String HEADER_LEN_STR = HTMLSupport.toPaddedString(HEADER_LEN, 10);
    private static final String TRAILER = "<!--EndFragment-->\r\n\u0000";

    HTMLSupport() {
    }

    private static String toPaddedString(int n, int n2) {
        String string = "" + n;
        int n3 = string.length();
        if (n >= 0 && n3 < n2) {
            char[] cArray = new char[n2 - n3];
            Arrays.fill(cArray, '0');
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray);
            stringBuffer.append(string);
            string = stringBuffer.toString();
        }
        return string;
    }

    public static byte[] convertToHTMLFormat(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(HEADER_LEN);
        stringBuffer.append(VERSION);
        stringBuffer.append(VERSION_NUM);
        stringBuffer.append(EOLN);
        stringBuffer.append(START_HTML);
        stringBuffer.append(HTML_START_END);
        stringBuffer.append(EOLN);
        stringBuffer.append(END_HTML);
        stringBuffer.append(HTML_START_END);
        stringBuffer.append(EOLN);
        stringBuffer.append(START_FRAGMENT);
        stringBuffer.append(HEADER_LEN_STR);
        stringBuffer.append(EOLN);
        stringBuffer.append(END_FRAGMENT);
        stringBuffer.append(HTMLSupport.toPaddedString(HEADER_LEN + byArray.length - 1, 10));
        stringBuffer.append(EOLN);
        stringBuffer.append(START_FRAGMENT_CMT);
        stringBuffer.append(EOLN);
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        try {
            byArray2 = new String(stringBuffer).getBytes(ENCODING);
            byArray3 = TRAILER.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray4 = new byte[byArray2.length + byArray.length - 1 + byArray3.length];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray4, byArray2.length, byArray.length - 1);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length + byArray.length - 1, byArray3.length);
        return byArray4;
    }
}

