/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.FileDescriptor;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Set;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;
import sun.nio.ch.FileChannelImpl;
import sun.nio.ch.SimpleAsynchronousFileChannelImpl;
import sun.nio.ch.ThreadPool;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixChannelFactory {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();

    protected UnixChannelFactory() {
    }

    static FileChannel newFileChannel(int n, String string, boolean bl, boolean bl2) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n);
        return FileChannelImpl.open(fileDescriptor, string, bl, bl2, null);
    }

    static FileChannel newFileChannel(int n, UnixPath unixPath, String string, Set<? extends OpenOption> set, int n2) throws UnixException {
        Flags flags = Flags.toFlags(set);
        if (!flags.read && !flags.write) {
            if (flags.append) {
                flags.write = true;
            } else {
                flags.read = true;
            }
        }
        if (flags.read && flags.append) {
            throw new IllegalArgumentException("READ + APPEND not allowed");
        }
        if (flags.append && flags.truncateExisting) {
            throw new IllegalArgumentException("APPEND + TRUNCATE_EXISTING not allowed");
        }
        FileDescriptor fileDescriptor = UnixChannelFactory.open(n, unixPath, string, flags, n2);
        return FileChannelImpl.open(fileDescriptor, unixPath.toString(), flags.read, flags.write, flags.append, null);
    }

    static FileChannel newFileChannel(UnixPath unixPath, Set<? extends OpenOption> set, int n) throws UnixException {
        return UnixChannelFactory.newFileChannel(-1, unixPath, null, set, n);
    }

    static AsynchronousFileChannel newAsynchronousFileChannel(UnixPath unixPath, Set<? extends OpenOption> set, int n, ThreadPool threadPool) throws UnixException {
        Flags flags = Flags.toFlags(set);
        if (!flags.read && !flags.write) {
            flags.read = true;
        }
        if (flags.append) {
            throw new UnsupportedOperationException("APPEND not allowed");
        }
        FileDescriptor fileDescriptor = UnixChannelFactory.open(-1, unixPath, null, flags, n);
        return SimpleAsynchronousFileChannelImpl.open(fileDescriptor, flags.read, flags.write, threadPool);
    }

    protected static FileDescriptor open(int n, UnixPath unixPath, String string, Flags flags, int n2) throws UnixException {
        int n3;
        SecurityManager securityManager;
        int n4;
        if (flags.read && flags.write) {
            n4 = 2;
        } else {
            int n5 = n4 = flags.write ? 1 : 0;
        }
        if (flags.write) {
            if (flags.truncateExisting) {
                n4 |= 0x400;
            }
            if (flags.append) {
                n4 |= 8;
            }
            if (flags.createNew) {
                byte[] byArray = unixPath.asByteArray();
                if (byArray[byArray.length - 1] == 46 && (byArray.length == 1 || byArray[byArray.length - 2] == 47)) {
                    throw new UnixException(17);
                }
                n4 |= 0xA00;
            } else if (flags.create) {
                n4 |= 0x200;
            }
        }
        boolean bl = true;
        if (!flags.createNew && (flags.noFollowLinks || flags.deleteOnClose)) {
            block30: {
                if (flags.deleteOnClose && !UnixNativeDispatcher.supportsNoFollowLinks()) {
                    try {
                        if (UnixFileAttributes.get(unixPath, false).isSymbolicLink()) {
                            throw new UnixException("DELETE_ON_CLOSE specified and file is a symbolic link");
                        }
                    }
                    catch (UnixException unixException) {
                        if (flags.create && unixException.errno() == 2) break block30;
                        throw unixException;
                    }
                }
            }
            bl = false;
            n4 |= 0x100;
        }
        if (flags.dsync) {
            n4 |= 0x400000;
        }
        if (flags.sync) {
            n4 |= 0x80;
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (string == null) {
                string = unixPath.getPathForPermissionCheck();
            }
            if (flags.read) {
                securityManager.checkRead(string);
            }
            if (flags.write) {
                securityManager.checkWrite(string);
            }
            if (flags.deleteOnClose) {
                securityManager.checkDelete(string);
            }
        }
        try {
            n3 = n >= 0 ? UnixNativeDispatcher.openat(n, unixPath.asByteArray(), n4, n2) : UnixNativeDispatcher.open(unixPath, n4, n2);
        }
        catch (UnixException unixException) {
            UnixException unixException2;
            if (flags.createNew && unixException.errno() == 21) {
                unixException.setError(17);
            }
            if (!bl && unixException.errno() == 62) {
                unixException2 = new UnixException(unixException.getMessage() + " (NOFOLLOW_LINKS specified)");
            }
            throw unixException2;
        }
        if (flags.deleteOnClose) {
            try {
                if (n >= 0) {
                    UnixNativeDispatcher.unlinkat(n, unixPath.asByteArray(), 0);
                } else {
                    UnixNativeDispatcher.unlink(unixPath);
                }
            }
            catch (UnixException unixException) {
                // empty catch block
            }
        }
        FileDescriptor fileDescriptor = new FileDescriptor();
        fdAccess.set(fileDescriptor, n3);
        return fileDescriptor;
    }

    protected static class Flags {
        boolean read;
        boolean write;
        boolean append;
        boolean truncateExisting;
        boolean noFollowLinks;
        boolean create;
        boolean createNew;
        boolean deleteOnClose;
        boolean sync;
        boolean dsync;

        protected Flags() {
        }

        static Flags toFlags(Set<? extends OpenOption> set) {
            Flags flags = new Flags();
            block12: for (OpenOption openOption : set) {
                if (openOption instanceof StandardOpenOption) {
                    switch ((StandardOpenOption)openOption) {
                        case READ: {
                            flags.read = true;
                            continue block12;
                        }
                        case WRITE: {
                            flags.write = true;
                            continue block12;
                        }
                        case APPEND: {
                            flags.append = true;
                            continue block12;
                        }
                        case TRUNCATE_EXISTING: {
                            flags.truncateExisting = true;
                            continue block12;
                        }
                        case CREATE: {
                            flags.create = true;
                            continue block12;
                        }
                        case CREATE_NEW: {
                            flags.createNew = true;
                            continue block12;
                        }
                        case DELETE_ON_CLOSE: {
                            flags.deleteOnClose = true;
                            continue block12;
                        }
                        case SPARSE: {
                            continue block12;
                        }
                        case SYNC: {
                            flags.sync = true;
                            continue block12;
                        }
                        case DSYNC: {
                            flags.dsync = true;
                            continue block12;
                        }
                    }
                    throw new UnsupportedOperationException();
                }
                if (openOption == LinkOption.NOFOLLOW_LINKS && UnixNativeDispatcher.supportsNoFollowLinks()) {
                    flags.noFollowLinks = true;
                    continue;
                }
                if (openOption == null) {
                    throw new NullPointerException();
                }
                throw new UnsupportedOperationException(openOption + " not supported");
            }
            return flags;
        }
    }
}

