/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.os.elf;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDescriptionRuntime;

public class Ehdr {
    StructAccessor accessor;
    private static final int mdIdx = MachineDescriptionRuntime.getStatic().ordinal();
    private static final int[] Ehdr_size = new int[]{52, 52, 64, 52, 52, 64};
    private static final int[] e_ident_offset = new int[]{0, 0, 0, 0, 0, 0};
    private static final int[] e_type_offset = new int[]{16, 16, 16, 16, 16, 16};
    private static final int[] e_machine_offset = new int[]{18, 18, 18, 18, 18, 18};
    private static final int[] e_version_offset = new int[]{20, 20, 20, 20, 20, 20};
    private static final int[] e_entry_offset = new int[]{24, 24, 24, 24, 24, 24};
    private static final int[] e_phoff_offset = new int[]{28, 28, 32, 28, 28, 32};
    private static final int[] e_shoff_offset = new int[]{32, 32, 40, 32, 32, 40};
    private static final int[] e_flags_offset = new int[]{36, 36, 48, 36, 36, 48};
    private static final int[] e_ehsize_offset = new int[]{40, 40, 52, 40, 40, 52};
    private static final int[] e_phentsize_offset = new int[]{42, 42, 54, 42, 42, 54};
    private static final int[] e_phnum_offset = new int[]{44, 44, 56, 44, 44, 56};
    private static final int[] e_shentsize_offset = new int[]{46, 46, 58, 46, 46, 58};
    private static final int[] e_shnum_offset = new int[]{48, 48, 60, 48, 48, 60};
    private static final int[] e_shstrndx_offset = new int[]{50, 50, 62, 50, 50, 62};

    public static int size() {
        return Ehdr_size[mdIdx];
    }

    public static Ehdr create() {
        return Ehdr.create(Buffers.newDirectByteBuffer(Ehdr.size()));
    }

    public static Ehdr create(ByteBuffer byteBuffer) {
        return new Ehdr(byteBuffer);
    }

    Ehdr(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public Ehdr setE_ident(byte[] byArray) {
        this.accessor.setBytesAt(e_ident_offset[mdIdx], byArray);
        return this;
    }

    public byte[] getE_ident() {
        return this.accessor.getBytesAt(e_ident_offset[mdIdx], new byte[16]);
    }

    public Ehdr setE_type(short s) {
        this.accessor.setShortAt(e_type_offset[mdIdx], s);
        return this;
    }

    public short getE_type() {
        return this.accessor.getShortAt(e_type_offset[mdIdx]);
    }

    public Ehdr setE_machine(short s) {
        this.accessor.setShortAt(e_machine_offset[mdIdx], s);
        return this;
    }

    public short getE_machine() {
        return this.accessor.getShortAt(e_machine_offset[mdIdx]);
    }

    public Ehdr setE_version(int n) {
        this.accessor.setIntAt(e_version_offset[mdIdx], n);
        return this;
    }

    public int getE_version() {
        return this.accessor.getIntAt(e_version_offset[mdIdx]);
    }

    public Ehdr setE_entry(long l) {
        this.accessor.setLongAt(e_entry_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getE_entry() {
        return this.accessor.getLongAt(e_entry_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Ehdr setE_phoff(long l) {
        this.accessor.setLongAt(e_phoff_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getE_phoff() {
        return this.accessor.getLongAt(e_phoff_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Ehdr setE_shoff(long l) {
        this.accessor.setLongAt(e_shoff_offset[mdIdx], l, MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
        return this;
    }

    public long getE_shoff() {
        return this.accessor.getLongAt(e_shoff_offset[mdIdx], MachineDescriptionRuntime.getStatic().md.longSizeInBytes());
    }

    public Ehdr setE_flags(int n) {
        this.accessor.setIntAt(e_flags_offset[mdIdx], n);
        return this;
    }

    public int getE_flags() {
        return this.accessor.getIntAt(e_flags_offset[mdIdx]);
    }

    public Ehdr setE_ehsize(short s) {
        this.accessor.setShortAt(e_ehsize_offset[mdIdx], s);
        return this;
    }

    public short getE_ehsize() {
        return this.accessor.getShortAt(e_ehsize_offset[mdIdx]);
    }

    public Ehdr setE_phentsize(short s) {
        this.accessor.setShortAt(e_phentsize_offset[mdIdx], s);
        return this;
    }

    public short getE_phentsize() {
        return this.accessor.getShortAt(e_phentsize_offset[mdIdx]);
    }

    public Ehdr setE_phnum(short s) {
        this.accessor.setShortAt(e_phnum_offset[mdIdx], s);
        return this;
    }

    public short getE_phnum() {
        return this.accessor.getShortAt(e_phnum_offset[mdIdx]);
    }

    public Ehdr setE_shentsize(short s) {
        this.accessor.setShortAt(e_shentsize_offset[mdIdx], s);
        return this;
    }

    public short getE_shentsize() {
        return this.accessor.getShortAt(e_shentsize_offset[mdIdx]);
    }

    public Ehdr setE_shnum(short s) {
        this.accessor.setShortAt(e_shnum_offset[mdIdx], s);
        return this;
    }

    public short getE_shnum() {
        return this.accessor.getShortAt(e_shnum_offset[mdIdx]);
    }

    public Ehdr setE_shstrndx(short s) {
        this.accessor.setShortAt(e_shstrndx_offset[mdIdx], s);
        return this;
    }

    public short getE_shstrndx() {
        return this.accessor.getShortAt(e_shstrndx_offset[mdIdx]);
    }
}

